<?php
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpFullyQualifiedNameUsageInspection */

namespace Illuminate\Contracts\View {

    /**
     * @method static void layoutData($data = [])
     * @method static void section($section)
     * @method static void title($title)
     * @method static void slot($slot)
     * @method static void extends($view, $params = [])
     * @method static void layout($view, $params = [])
     * @method static void response(callable $callback)
     */
    class View {}
}

namespace Illuminate\Database\Eloquent {

    /**
     * @method static void downloadExcel(string $fileName, string $writerType = null, $withHeadings = false)
     * @method static void storeExcel(string $filePath, string $disk = null, string $writerType = null, $withHeadings = false)
     * @method static void import(string $filename, string $disk = null, string $readerType = null)
     * @method static void importAs(string $filename, callable $mapping, string $disk = null, string $readerType = null)
     */
    class Builder {}
}

namespace Illuminate\Http {

    /**
     * @method static array validate(array $rules, ...$params)
     * @method static array validateWithBag(string $errorBag, array $rules, ...$params)
     * @method static bool hasValidSignature($absolute = true)
     * @method static bool hasValidRelativeSignature()
     * @method static bool hasValidSignatureWhileIgnoring($ignoreQuery = [], $absolute = true)
     * @method static bool hasValidRelativeSignatureWhileIgnoring($ignoreQuery = [])
     */
    class Request {}
}

namespace Illuminate\Routing {

    /**
     * @method static array|Route role($roles = [])
     * @method static array|Route permission($permissions = [])
     * @method static void lazy($enabled = true)
     */
    class Route {}
}

namespace Illuminate\Support {

    use Hekmatinasser\Verta\Verta;

    /**
     * @method static Verta toJalali($timezone = null)
     */
    class Carbon {}

    /**
     * @method static void downloadExcel(string $fileName, string $writerType = null, $withHeadings = false, array $responseHeaders = [])
     * @method static void storeExcel(string $filePath, string $disk = null, string $writerType = null, $withHeadings = false)
     */
    class Collection {}
}

namespace Illuminate\Support\Facades {

    /**
     * @method static void emailVerification()
     * @method static void auth($options = [])
     * @method static void resetPassword()
     * @method static void confirmPassword()
     */
    class Route {}
}

namespace Illuminate\Testing {

    /**
     * @method static void assertSeeLivewire($component)
     * @method static void assertDontSeeLivewire($component)
     */
    class TestResponse {}

    /**
     * @method static void assertSeeLivewire($component)
     * @method static void assertDontSeeLivewire($component)
     */
    class TestView {}
}

namespace Illuminate\View {

    use Livewire\WireDirective;

    /**
     * @method static WireDirective wire($name)
     */
    class ComponentAttributeBag {}

    /**
     * @method static void layoutData($data = [])
     * @method static void section($section)
     * @method static void title($title)
     * @method static void slot($slot)
     * @method static void extends($view, $params = [])
     * @method static void layout($view, $params = [])
     * @method static void response(callable $callback)
     */
    class View {}
}

namespace Laravel\Dusk {

    /**
     * @method static $this runScript($js)
     * @method static __anonymous@5808 waitForLivewire($callback = null)
     * @method static $this assertClassMissing($selector, $className)
     * @method static __anonymous@9630 waitForNavigate($callback = null)
     * @method static $this assertConsoleLogMissingWarning($expectedMessage)
     * @method static $this assertConsoleLogHasWarning($expectedMessage)
     * @method static __anonymous@14260 waitForNoNavigateRequest($callback = null)
     * @method static $this assertAttributeMissing($selector, $attribute)
     * @method static __anonymous@12225 waitForNavigateRequest($callback = null)
     * @method static $this selectMultiple($field, $values = [])
     * @method static void waitForLivewireToLoad()
     * @method static \Closure assertNotInViewPort($selector)
     * @method static $this scrollTo($selector)
     * @method static __anonymous@7719 waitForNoLivewire($callback = null)
     * @method static $this assertInViewPort($selector, $invert = false)
     * @method static void offline()
     * @method static $this assertScript($js, $expects = true)
     * @method static $this assertHasClass($selector, $className)
     * @method static void online()
     * @method static $this assertNotPresent($selector)
     * @method static $this assertNotVisible($selector)
     */
    class Browser {}
}
