
<?php if(!blank($item->photo && is_file($item->photo->path))): ?>
<?php $__env->startSection('title_seo'); ?>
  <meta name="twitter:image" content="<?php echo e(url($item->photo->path)); ?>"/>
  <meta property="og:image" content="<?php echo e(url($item->photo->path)); ?>"/>
<?php $__env->stopSection(); ?>
<?php endif; ?>
<?php $__env->startSection('styles'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
  <!--blog list section start-->
  <section class="blog-list-section ptb-120">
    <div class="container">
      <div class="row">
        <div class="col-xl-8">
          <div class="blog-single-area bg-white rounded">
            <div class="bs-blog-meta d-flex align-items-center justify-content-between">
              <a href="<?php echo e(route('front.blog.list','news')); ?>" class="btn-meta fw-bold"><?php echo e($item->type=='article'?read_lang_word('article'):read_lang_word('news')); ?></a>
              <?php if(app()->getLocale() == 'fa'): ?>
                <span class="date" dir="rtl"><?php echo e(my_jdate($item->created_at,'d F Y')); ?></span>
              <?php else: ?>
                <span class="date"><?php echo e(Carbon\Carbon::parse($item->created_at)->toFormattedDateString()); ?></span>
              <?php endif; ?>
            </div>
            <h3 class="blog-title mt-3"><?php echo e(read_lang($item,'title')); ?></h3>
            <div class="bs-blog-thumb position-relative mt-40 mb-4">
              <span class="btn-meta text-primary bg-white position-absolute z-2"><span class="<?php echo e(dir_set()=='ltr'?'me-1':'ms-1'); ?>"><i class="fas fa-eye"></i></span><?php echo e($item->seen); ?>

                <span class="<?php echo e(dir_set()=='ltr'?'ms-2 me-1':'me-2 ms-1'); ?>"><i class="fas fa-user"></i></span><?php echo e(read_lang($item,'author')); ?>

              </span>
              <img src="<?php echo e($item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/blog/blog-list-1.jpg')); ?>" alt="<?php echo e(photo_alt($item,'photo',read_lang($item,'title'))); ?>" class="img-fluid">
            </div>
            <?php echo read_lang($item,'text'); ?>

           <hr class="mt-40 mb-40">
            <div class="tags-social d-flex align-items-center justify-content-between flex-wrap">
              <?php if(count($tags)): ?>
              <div class="tags-list">
                <span class="title text-secondary fw-bold <?php echo e(dir_set()=='ltr'?'me-2':'ms-2'); ?>"><?php echo e(read_lang_word('keywords')); ?>:</span>
                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_word): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('front.tag.show',[$item->slug])); ?>"><?php echo e(read_lang($key_word,'title')); ?></a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
              <?php endif; ?>
              <div class="bs_social_share">
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('front.blog.show',[$item->slug])); ?>&t=<?php echo e(read_lang($item,'title')); ?>"><i class="fab fa-facebook-f"></i></a>
                <a href="whatsapp://send?text=<?php echo e(route('front.blog.show',[$item->slug])); ?> <?php echo e(read_lang($item,'title')); ?>"><i class="fab fa-whatsapp"></i></a>
                <a href="https://twitter.com/share?text=<?php echo e($item->title); ?>&url=<?php echo e(route('front.blog.show',[$item->slug])); ?>"><i class="fab fa-twitter"></i></a>
                <a href="https://telegram.me/share/url?url=<?php echo e(route('front.blog.show',[$item->slug])); ?>&text=<?php echo e(read_lang($item,'title')); ?>"><i class="fab fa-telegram"></i></a>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-4">
          <div class="blog-sidebar mt-60 mt-xl-0">
            <div class="sidebar-widget recent_post-widget bg-white widget-padding rounded">
              <div class="widget-top d-flex">
                <h5 class="mb-0 flex-shrink-0"><?php echo e(read_lang_word('recent-blog')); ?></h5>
                <span class="spacer align-self-end"></span>
              </div>
              <ul class="recent_posts_list mt-30">
                <?php $__currentLoopData = $items_last; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $last): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="d-flex align-items-center">
                  <div class="thumb-wrapper">
                    <a href="<?php echo e(route('front.blog.show',[$last->slug])); ?>"><img src="<?php echo e($last->photo && is_file($last->photo->path)?url($last->photo->path):url('assets/front/img/blog/recent-post-1.jpg')); ?>" alt="<?php echo e(photo_alt($last,'photo',read_lang($last,'title'))); ?>" class="img-fluid"></a>
                  </div>
                  <div class="rp_content">
                    <a href="<?php echo e(route('front.blog.show',[$last->slug])); ?>" class="mb-1"><?php echo e(read_lang($last,'title')); ?></a>
                    <span class="date"><?php echo e(Carbon\Carbon::parse($last->created_at)->toFormattedDateString()); ?></span>
                  </div>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <div class="sidebar-widget recent_post-widget bg-white widget-padding rounded mt-4">
              <div class="widget-top d-flex">
                <h5 class="mb-0 flex-shrink-0"><?php echo e(read_lang_word('most-visited')); ?></h5>
                <span class="spacer align-self-end"></span>
              </div>
              <ul class="recent_posts_list mt-30">
                <?php $__currentLoopData = $items_seen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li class="d-flex align-items-center">
                    <div class="thumb-wrapper">
                      <a href="<?php echo e(route('front.blog.show',[$seen->slug])); ?>"><img src="<?php echo e($seen->photo && is_file($seen->photo->path)?url($seen->photo->path):url('assets/front/img/blog/recent-post-1.jpg')); ?>" alt="<?php echo e(photo_alt($seen,'photo',read_lang($seen,'title'))); ?>" class="img-fluid"></a>
                    </div>
                    <div class="rp_content">
                      <a href="<?php echo e(route('front.blog.show',[$last->slug])); ?>" class="mb-1"><?php echo e(read_lang($seen,'title')); ?></a>
                      <span class="date"><?php echo e(Carbon\Carbon::parse($seen->created_at)->toFormattedDateString()); ?></span>
                    </div>
                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!--blog list section end-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?> <?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/edenpetro/public_html/source/resources/views/front/blog/show.blade.php ENDPATH**/ ?>