

<?php $__env->startSection('content'); ?>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        <?php echo e($title); ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_create')): ?>
                        <a href="<?php echo e(route('admin.product.create')); ?>" class="btn btn-primary float-left">افزودن</a>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">عنوان</th>
                                <th class="border-bottom-0">دسته بندی</th>
                                <th class="border-bottom-0">تصویر</th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_edit','product_delete'])): ?>
                                <th class="border-bottom-0">عملیات</th>
                                <?php endif; ?>    
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td>
                                       <?php echo e($item->title); ?>

                                    </td>
                                    <td>
                                       <?php echo e($item->category?$item->category->title:'__'); ?>

                                    </td>
                                    <td>
                                        <?php if($item->photo && is_file($item->photo->path)): ?>
                                            <img src="<?php echo e(url($item->photo->path)); ?>" height="100px">
                                        <?php else: ?>
                                            ثبت نشده
                                        <?php endif; ?>
                                    </td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['product_edit','product_delete'])): ?>
                                        <td>
                                            <div class="d-flex">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_edit')): ?>
                                                    <a href="<?php echo e(route('admin.product.edit',$item->id)); ?>"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="ویرایش"></i>
                                                    </a>
                                                <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_delete')): ?>
                                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['admin.product.destroy', $item->id] ]); ?>

                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="حذف"
                                                            onclick="return confirm('برای حذف مطمئن هستید؟')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    <?php echo Form::close(); ?>

                                                    <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app',['tbl'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/newcarosha/public_html/back2/source/resources/views/admin/product/index.blade.php ENDPATH**/ ?>