<?php $__env->startSection('styles'); ?>
    <style>
        .group-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            min-width: 200px;
            background: #f8f9fa;
            margin-bottom: 20px;
        }


        .student-row {
            cursor: move;
            margin-bottom: 5px;
            padding: 5px;
            background: #fff;
            border: 1px solid #ccc;
            border-radius: 4px;
            width: fit-content;
        }

        .group-title {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .group-container {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }

        .student-row {
            list-style-type: none !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="modal" id="mymodal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">افزودن گروه</h5>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('admin.add_group', $edu->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="">
                            <label for="">نام گروه</label>
                            <input type="text" name="gp_name" class="form-control">
                        </div>

                        <div class="mt-2">
                            <label for="">زمان شروع</label>
                            <input type="text" name="gp_date_start" class="form-control date-picker">
                        </div>

                        <div class="mt-2">
                            <label for="">زمان پایان</label>
                            <input type="text" name="gp_date_end" class="form-control date-picker">
                        </div>

                        <button class="btn btn-success mt-2">ایجاد</button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-close" data-bs-dismiss="modal">Close</button>
                    
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        <?php echo e($title); ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_create')): ?>
                            <a href="<?php echo e(route('admin.manage-educations.create')); ?>"
                                class="btn btn-primary float-left">افزودن</a>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="card-body">
                    <div class="container mt-5">
                        <div class="mb-3">
                            <button class="btn btn-primary" id="addGroupBtn">افزودن گروه</button>
                        </div>

                        <form action="<?php echo e(route('admin.edu_groups.update', $edu->id)); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="group-container" id="groupsContainer">
                                <?php $__currentLoopData = $edu->groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $gp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="group-card" data-group-id="<?php echo e($gp->id); ?>">
                                        <div class="group-title"><?php echo e($gp->name); ?></div>
                                        <div class="group-title text-info"> شروع:
                                            <?php echo e(my_jDate($gp->start_time, 'Y-m-d H:i:s')); ?></div>
                                        <div class="group-title text-primary"> پایان:
                                            <?php echo e(my_jDate($gp->end_time, 'Y-m-d H:i:s')); ?></div>
                                        <hr>
                                        <ul class="student-list list-unstyled">
                                            <?php $__currentLoopData = $gp->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="student-row" data-student-id="<?php echo e($user->id); ?>">
                                                    <?php echo e($user->name); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>

                                        <input class="hideInput" type="hidden" name="input_group[<?php echo e($gp->id); ?>]"
                                            value="<?php echo e(implode(',', $gp->users->pluck('id')->toArray()) ?? ''); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                            </div>

                            <h4 class="mt-5">دانش آموزان بدون گروه</h4>
                            <div id="unassignedStudents">
                                <?php $__currentLoopData = $edu->nonGroupUsers(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="student-row" data-student-id="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                            </div>

                            <button class="btn btn-success mt-3" id="saveBtn">ذخیره تغییرات</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script>
        document.getElementById('addGroupBtn').addEventListener('click', () => {
            var modal = new bootstrap.Modal(document.getElementById('mymodal'));
            modal.show();

            $('.btn-close').click(function() {
                console.log("triggerd");

                modal.hide()
            })
        });
    </script>
    <script>
        $(".date-picker").pDatepicker({
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true
            },
            autoClose: true,
            initialValue: false
        });
    </script>
    <script>
        $(function() {

            function updateHiddenInput($groupCard) {
                if (!$groupCard || !$groupCard.length) return;
                var ids = $groupCard.find('.student-list .student-row').map(function() {
                    return $(this).data('student-id');
                }).get();
                $groupCard.find('.hideInput').val(ids.length ? ids.join(',') : '');
                console.log('group', $groupCard.data('group-id'), '->', ids);
            }


            function makeDraggable() {
                $(document).on('mousedown touchstart', '.student-row', function() {

                    if (!$(this).data('ui-draggable')) {
                        $(this).draggable({
                            revert: 'invalid',
                            scroll: false,
                            containment: 'document',
                            start: function(e, ui) {
                                var $me = $(this);
                                var origin = $me.closest('.group-card').data('group-id');
                                $me.data('origin', origin === undefined ? 'unassigned' :
                                origin);
                                ui.helper.css('z-index', 2000);
                            }
                        });
                    }
                });
            }


            function makeDroppables() {

                $('.group-card').droppable({
                    tolerance: 'pointer',
                    accept: '.student-row',
                    drop: function(e, ui) {
                        var $targetCard = $(this);
                        var id = ui.draggable.data('student-id');


                        var $real = $('.student-row[data-student-id="' + id + '"]').first();
                        $('.student-row[data-student-id="' + id + '"]').not($real).remove();


                        $real.detach().appendTo($targetCard.find('.student-list')).css({
                            position: 'relative',
                            top: 0,
                            left: 0
                        });


                        updateHiddenInput($targetCard);


                        var originId = ui.draggable.data('origin');
                        if (originId && originId !== 'unassigned') {
                            var $originCard = $('.group-card[data-group-id="' + originId + '"]');
                            updateHiddenInput($originCard);
                        }

                        $real.data('origin', $targetCard.data('group-id'));
                    }
                });


                $('#unassignedStudents').droppable({
                    tolerance: 'pointer',
                    accept: '.student-row',
                    drop: function(e, ui) {
                        var $target = $(this);
                        var id = ui.draggable.data('student-id');

                        var $real = $('.student-row[data-student-id="' + id + '"]').first();
                        $('.student-row[data-student-id="' + id + '"]').not($real).remove();

                        $real.detach().appendTo($target).css({
                            position: 'relative',
                            top: 0,
                            left: 0
                        });

                        var originId = ui.draggable.data('origin');
                        if (originId && originId !== 'unassigned') {
                            var $originCard = $('.group-card[data-group-id="' + originId + '"]');
                            updateHiddenInput($originCard);
                        }

                        $real.data('origin', 'unassigned');
                    }
                });
            }

            $('#addGrou2pBtn').on('click', function() {
                var name = prompt('نام گروه را وارد کنید:');
                if (!name) return;
                var id = Date.now();
                var $card = $(`
          <div class="group-card" data-group-id="${id}">
            <div class="group-title">${name}</div>
            <ul class="student-list list-unstyled"></ul>
            <input class="hideInput" type="hidden" name="input_group[${id}]" value="">
          </div>
        `);
                $('#groupsContainer').append($card);

                makeDroppables();
            });

            makeDraggable();
            makeDroppables();

            $('.group-card').each(function() {
                updateHiddenInput($(this));
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', ['tbl' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amarsara/public_html/back/source/resources/views/admin/education/groups/groups.blade.php ENDPATH**/ ?>