<header class="rent-header position-relative z-2 header-sticky">
    <div class="rent-header-info position-relative z-2">
        <div class="container">
            <div class="row" dir="ltr">
                <div class="col-xl-9 col-lg-4 col-6">
                    <div class="rent-hero-info-left d-flex align-items-center justify-content-between">
                        <div class="tp-info-wrapper d-flex align-items-center">
                            <?php if(!blank(read_lang($contact_info,'address'))): ?>
                                <div class="d-none tp-info d-xl-inline-flex align-items-center">
                                        <span class="icon-wrapper me-2">
                                          <i class="flaticon-location"></i>
                                      </span>
                                    <p class="mb-0"><?php echo e(read_lang($contact_info,'address')); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if(!blank($contact_info->mobile) && explode(',',$contact_info->mobile)>0): ?>
                                <div class="tp-info d-inline-flex align-items-center">
                                        <span class="icon-wrapper me-2">
                                          <i class="flaticon-phone-call"></i>
                                      </span>
                                    <a href="tel:<?php echo e(str_replace([' ','-','_'],'',explode(',',$contact_info->mobile)[0])); ?>"
                                       target="_blank"
                                       rel="nofollow noopener noreferrer" class="mb-0"
                                       dir="ltr"><?php echo e(explode(',',$contact_info->mobile)[0]); ?></a>
                                </div>
                            <?php endif; ?>
                            <?php if(!blank($contact_info->email) && explode(',',$contact_info->email)>0): ?>
                                <div class="d-none tp-info d-xl-inline-flex align-items-center">
                                        <span class="icon-wrapper me-2">
                                          <i class="flaticon-email"></i>
                                      </span>
                                    <a href="mailto:<?php echo e(explode(',',$contact_info->email)[0]); ?>" target="_blank"
                                       rel="nofollow noopener noreferrer" class="mb-0"
                                       dir="ltr"><?php echo e(explode(',',$contact_info->email)[0]); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if(count(menu_langs()) > 1): ?>
                            <div class="lang-switcher d-none d-md-block">
                                <div class="dropdown">
                                    <button data-bs-toggle="dropdown" class="bg-transparent fs-md fw-500"><img
                                                src="<?php echo e(site_lang()->photo ? url(site_lang()->photo->path) : ''); ?>"
                                                alt="<?php echo e(site_lang()->lang); ?>"
                                                class="flag me-3 rounded-circle"><?php echo e(strtoupper(site_lang()->lang)); ?><span
                                                class="ms-2"><i class="fas fa-angle-down"></i></span></button>
                                    <ul class="dropdown-menu dropdown-menu-end z-2">
                                        <?php $__currentLoopData = menu_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang->lang, null, [], true)); ?>"><img
                                                            src="<?php echo e($lang->photo ? url($lang->photo->path) : ''); ?>"
                                                            alt="<?php echo e($lang->lang); ?>"
                                                            class="flag me-2 rounded-circle"><?php echo e(strtoupper($lang->lang)); ?>

                                                </a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-8 col-6">
                    <div class="rent-info-social text-end d-none d-sm-block">
                        <?php if($contact_info->telegram): ?>
                            <a href="<?php echo e($contact_info->telegram); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-telegram"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->instagram): ?>
                            <a href="<?php echo e($contact_info->instagram); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->facebook): ?>
                            <a href="<?php echo e($contact_info->facebook); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->twitter): ?>
                            <a href="<?php echo e($contact_info->twitter); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->youtube): ?>
                            <a href="<?php echo e($contact_info->youtube); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-youtube"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->linkedin): ?>
                            <a href="<?php echo e($contact_info->linkedin); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-linkedin"></i></a>
                        <?php endif; ?>
                        <?php if($contact_info->whatsapp_group): ?>
                            <a href="<?php echo e($contact_info->whatsapp_group); ?>" target="_blank"
                               rel="nofollow noopener noreferrer"><i class="fab fa-whatsapp"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="at_header_nav position-relative z-1">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-6 col-lg-9">
                    <div class="at_header_right d-flex align-items-center justify-content-start">
                        <nav class="at_nav_menu d-none d-lg-block">
                            <ul>
                                <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(read_lang_word('home')); ?></a></li>
                                <li class="has-submenu">
                                    <a href="<?php echo e(route('front.about.us')); ?>"><?php echo e(read_lang_word('about')); ?></a>
                                    <ul class="submenu-wrapper">
                                        <li><a href="<?php echo e(route('front.about.us','who-are-we')); ?>"><?php echo e(read_lang_word('about-who')); ?></a></li>
                                        <li><a href="<?php echo e(route('front.about.us','our-vision')); ?>"><?php echo e(read_lang_word('about-vision')); ?></a></li>
                                        <li><a href="<?php echo e(route('front.about.us','our-mission')); ?>"><?php echo e(read_lang_word('about-mission')); ?></a></li>
                                        <li><a href="<?php echo e(route('front.about.us','our-team')); ?>"><?php echo e(read_lang_word('about-team')); ?></a></li>
                                    </ul>
                                </li>
                                <li class="<?php echo e(count($cats_menu) ? 'has-submenu' : ''); ?>">
                                    <a href="<?php echo e(route('front.product.list')); ?>"><?php echo e(read_lang_word('products')); ?></a>
                                    <?php if(count($cats_menu)): ?>
                                        <ul class="submenu-wrapper">
                                            <?php $__currentLoopData = $cats_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="<?php echo e(count($cat_menu->childs_active) ? 'has-submenu' : ''); ?>">
                                                    <a href="<?php echo e(route('front.product.list',$cat_menu->slug)); ?>"><?php echo e(read_lang($cat_menu,'title')); ?></a>
                                                    <?php if(count($cat_menu->childs_active)): ?>
                                                        <ul class="submenu-wrapper">
                                                            <?php $__currentLoopData = $cat_menu->childs_active; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    <a href="<?php echo e(route('front.product.list',$child_menu->slug)); ?>"><?php echo e(read_lang($child_menu,'title')); ?></a>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php endif; ?>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                                <li><a href="<?php echo e(route('front.certificate')); ?>"><?php echo e(read_lang_word('certificates')); ?></a></li>
                                <li><a href="<?php echo e(route('front.contact.us')); ?>"><?php echo e(read_lang_word('contact')); ?></a></li>
                            </ul>
                        </nav>
                        <div class="apt_header_search dropdown ms-4">
                            <button class="apt_search_toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end p-0 border border-1 rounded overflow-hidden"
                                 style="">
                                <form class="d-flex align-items-center">
                                    <input type="text" placeholder="Search...">
                                    <button type="submit"
                                            class="bg-transparent text-secondary fw-bold border-start px-3">Go
                                    </button>
                                </form>
                            </div>
                        </div>
                        <button class="mobile-menu-toggle header-toggle-btn ms-4 d-lg-none">
                            <span></span>
                            <span></span>
                            <span></span>
                        </button>
                    </div>
                </div>
                <div class="col-6 col-lg-3">
                    <div class="logo-wrapper text-endd">
                        <a href="<?php echo e(route('front.index')); ?>"><img src="<?php echo e($logo); ?>" alt="<?php echo e($titleSeo); ?>"></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header><?php /**PATH /home/adlim/public_html/source/resources/views/front/layouts/includes_front/header_new.blade.php ENDPATH**/ ?>