<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(dir_set()); ?>">
<head>
  <!--required meta tags-->
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

  <title><?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?></title>
  <!--og-->
  <meta property="og:title" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>" />
  <meta property="og:description" content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>
  <meta property="og:site_name" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>" />
  <!--twitter og-->
  <meta name="twitter:title" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>"/>
  <meta name="twitter:description"  content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>
  <!--facebook og-->
  <meta name="description" content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>

  <meta name="robots" content="<?php echo e($robots); ?>"/>
  <link rel="canonical" href="<?php echo e($canonical); ?>" />

  <?php if(trim($__env->yieldContent('og_img'))): ?>
    <?php echo $__env->yieldContent('og_img'); ?>
  <?php else: ?>
    <meta name="twitter:image" content="<?php echo e($fav_icon); ?>"/>
    <meta property="og:image" content="<?php echo e($fav_icon); ?>"/>
  <?php endif; ?>
  <meta name="author" content="https://adib.com.tr/"/>
  <link rel="alternate" hreflang="<?php echo e(app()->getLocale()); ?>" href="<?php echo e(asset('/')); ?>" />

  <?php if(!blank($schemaSeo)): ?>
    <?php echo $schemaSeo; ?>

  <?php endif; ?>

  <link rel="icon" href="<?php echo e($fav_icon); ?>" sizes="16x16"/>

  <meta name="base_url" content="<?php echo e(url('')); ?>">

  

  <!-- Dark mode -->
    <script>
      const storedTheme = localStorage.getItem("theme");

      const getPreferredTheme = () => {
        if (storedTheme) {
          return storedTheme;
        }
        return window.matchMedia("(prefers-color-scheme: dark)").matches
          ? "dark"
          : "light";
      };

      const setTheme = function (theme) {
        if (
          theme === "auto" &&
          window.matchMedia("(prefers-color-scheme: dark)").matches
        ) {
          document.documentElement.setAttribute("data-bs-theme", "dark");
        } else {
          document.documentElement.setAttribute("data-bs-theme", theme);
        }
      };

      setTheme(getPreferredTheme());

      window.addEventListener("DOMContentLoaded", () => {
        var el = document.querySelector(".theme-icon-active");
        if (el != "undefined" && el != null) {
          const showActiveTheme = (theme) => {
            const activeThemeIcon = document.querySelector(
              ".theme-icon-active use"
            );
            const btnToActive = document.querySelector(
              `[data-bs-theme-value="${theme}"]`
            );
            const svgOfActiveBtn = btnToActive
              .querySelector(".mode-switch use")
              .getAttribute("href");

            document
              .querySelectorAll("[data-bs-theme-value]")
              .forEach((element) => {
                element.classList.remove("active");
              });

            btnToActive.classList.add("active");
            activeThemeIcon.setAttribute("href", svgOfActiveBtn);
          };

          window
            .matchMedia("(prefers-color-scheme: dark)")
            .addEventListener("change", () => {
              if (storedTheme !== "light" || storedTheme !== "dark") {
                setTheme(getPreferredTheme());
              }
            });

          showActiveTheme(getPreferredTheme());

          document
            .querySelectorAll("[data-bs-theme-value]")
            .forEach((toggle) => {
              toggle.addEventListener("click", () => {
                const theme = toggle.getAttribute("data-bs-theme-value");
                localStorage.setItem("theme", theme);
                setTheme(theme);
                showActiveTheme(theme);
              });
            });
        }
      });
    </script>

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/front/images/logo.png')); ?>" />

    <!-- Plugins CSS -->
    <link
      rel="stylesheet"
      type="text/css"
      href="<?php echo e(asset('assets/front/vendor/font-awesome/css/all.min.css')); ?>"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="<?php echo e(asset('assets/front/vendor/bootstrap-icons/bootstrap-icons.css')); ?>"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="<?php echo e(asset('assets/front/vendor/tiny-slider/tiny-slider.css')); ?>"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="<?php echo e(asset('assets/front/vendor/glightbox/css/glightbox.css')); ?>"
    />

    

<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/front/css/style-rtl.css')); ?>" />

  <?php if(dir_set()=='rtl'): ?>
    
    <!-- Theme CSS -->
    
  <?php endif; ?>
  
 
<?php echo $__env->yieldContent('styles'); ?>
</head>
<body>
<!--main content wrapper start-->
<div class="main-wrapper">

  
  

   

  

  <?php echo $__env->yieldContent('body'); ?>
  <?php if (isset($component)) { $__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa = $attributes; } ?>
<?php $component = App\View\Components\Footer::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Footer::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa)): ?>
<?php $attributes = $__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa; ?>
<?php unset($__attributesOriginal99051027c5120c83a2f9a5ae7c4c3cfa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa)): ?>
<?php $component = $__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa; ?>
<?php unset($__componentOriginal99051027c5120c83a2f9a5ae7c4c3cfa); ?>
<?php endif; ?>

  

</div>

<!--scrolltop button-->

<!--scrolltop button end-->

<!--build:js-->

<!--endbuild-->
<!-- sweetalert2 js-->



<div class="back-top">
    <i
    class="bi bi-arrow-up-short position-absolute top-50 start-50 translate-middle"
    ></i>
</div>

<script src="<?php echo e(asset('assets/front/js/jquery.js')); ?>"></script>

<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/front/vendor/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>

<!-- Vendors -->
<script src="<?php echo e(asset('assets/front/vendor/tiny-slider/tiny-slider-rtl.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/vendor/glightbox/js/glightbox.js')); ?>"></script>

<!-- Template Functions -->
<script src="<?php echo e(asset('assets/front/js/functions.js')); ?>"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
  <?php if(session()->has('err_message')): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
          text: "<?php echo e(session('err_message')); ?>",
          icon: "warning",
          timer: 6000,
          timerProgressBar: true,
      })
  });
  <?php endif; ?>
  <?php if(session()->has('flash_message')): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('successful')); ?>",
          text: "<?php echo e(session('flash_message')); ?>",
          icon: "success",
          timer: 6000,
          timerProgressBar: true,
      })
  })
  ;<?php endif; ?>
  <?php if(count($errors) > 0): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
          icon: "warning",
          html:
                  <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      '<p class="text-right mt-2 ml-5" dir="rtl"> <?php echo e($key+1); ?> : ' +
              '<?php echo e($error); ?>' +
              '</p>' +
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      '<p class="text-right mt-2 ml-5" dir="rtl">' +
              '</p>',
          timer: <?php if(count($errors)>3): ?>parseInt('<?php echo e(count($errors)); ?>') * 1500 <?php else: ?> 6000 <?php endif; ?>,
          timerProgressBar: true,
      })
  });
  <?php endif; ?>
</script>
<?php echo $__env->yieldContent('scripts'); ?>


</body>
</html>
<?php /**PATH /home/amarsara/public_html/back/source/resources/views/front/layouts/front.blade.php ENDPATH**/ ?>