<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>

    <!-- Meta data -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
<!-- Title -->
    <title><?php echo e($setting->title); ?></title>
    <meta name="base_url" content="<?php echo e(url('')); ?>">
    <!--Favicon -->
    <link rel="icon" href="<?php echo e($setting->icon && $setting->icon->path?url($setting->icon->path):''); ?>" type="image/x-icon"/>
    <?php echo $__env->make('layouts.style.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(URL::asset('assets/plugins/selectize/css.css')); ?>">
    <?php if(isset($tbl)): ?>
        <?php echo $__env->make('layouts.style.tbl', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php if(isset($file_upload)): ?>
        <link href="<?php echo e(URL::asset('assets/plugins/fileupload/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>
    <?php endif; ?>
    <?php if(isset($date_picker)): ?>
        <link href="<?php echo e(URL::asset('assets/plugins/date-picker/persian-datepicker.css')); ?>" rel="stylesheet"/>
    <?php endif; ?>
    <?php if(isset($progress)): ?>
        <link href="<?php echo e(URL::asset('assets/plugins/progress/normalize.css')); ?>" rel="stylesheet"/>
        <link href="<?php echo e(URL::asset('assets/plugins/progress/asPieProgress.css')); ?>" rel="stylesheet"/>
    <?php endif; ?>
</head>

<body class="app sidebar-mini" id="index1">

<!---Global-loader-->
<div id="global-loader">
    <img src="<?php echo e(URL::asset('assets/images/svgs/loader.svg')); ?>" alt="loader">
</div>
<div id="global-loader-form" style="display: none">
    <img src="<?php echo e(URL::asset('assets/images/svgs/loader.svg')); ?>" alt="loader">
    <p class="text-center">در حال بارگذاری اطلاعات ...</p>
</div>
<div class="page">
    <div class="page-main">
        <?php if(Auth::check()): ?>
            <?php echo $__env->make('layouts.menu.hr-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <div class="app-content main-content">
            <div class="side-app">
                <?php if(Auth::check()): ?>
                    <?php echo $__env->make('layouts.header.app-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
                <?php if(isset($url_back)): ?>
                    <a href="<?php echo e($url_back); ?>" class="btn btn-danger back_btn_all ml-1"
                       onclick="return confirm('برای بازگشت مطمئن هستید؟')"  data-toggle="tooltip"
                       data-placement="top" title="بازگشت"><span class="feather feather-chevrons-right"></span> </a>
                <?php endif; ?>
            </div>
        </div><!-- end app-content-->
    </div>

    <?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


</div>

<?php echo $__env->make('layouts.script.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript" src="<?php echo e(URL::asset('assets/plugins/selectize/js.js')); ?>"></script>
<?php if(isset($tbl)): ?>
    <?php echo $__env->make('layouts.script.tbl', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php if(isset($req)): ?>
    <?php echo $__env->make('layouts.script.req', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<!-- Custom js-->
<?php if(isset($req)): ?>
    <?php echo $__env->make('layouts.script.req', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php if(isset($date_picker)): ?>
    <?php echo $__env->make('layouts.script.date_picker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php if(isset($price_k)): ?>
    <script src="https://cdn.jsdelivr.net/gh/mahmoud-eskandari/NumToPersian/dist/num2persian-min.js"></script>
<?php endif; ?>
<?php if(isset($editor)): ?>
    <script src="<?php echo e(url('assets/editor/laravel-ckeditor/ckeditor.js')); ?>"></script>
    <script src="<?php echo e(url('assets/editor/laravel-ckeditor/adapters/jquery.js')); ?>"></script>
    <script type="text/javascript">
        var textareaRtl = {
            filebrowserImageBrowseUrl: '<?php echo e(url('filemanager?type=Images')); ?>',
            filebrowserImageUploadUrl: '<?php echo e(url('filemanager/upload?type=Images&_token=')); ?>',
            filebrowserBrowseUrl: '<?php echo e(url('filemanager?type=Files')); ?>',
            filebrowserUploadUrl: '<?php echo e(url('filemanager/upload?type=Files&_token=')); ?>',
            language: 'fa',

        };
        $('.textarea_rtl').ckeditor(textareaRtl);

        var textareaLtr = {
            filebrowserImageBrowseUrl: '<?php echo e(url('filemanager?type=Images')); ?>',
            filebrowserImageUploadUrl: '<?php echo e(url('filemanager/upload?type=Images&_token=')); ?>',
            filebrowserBrowseUrl: '<?php echo e(url('filemanager?type=Files')); ?>',
            filebrowserUploadUrl: '<?php echo e(url('filemanager/upload?type=Files&_token=')); ?>',
            language: 'en',

        };
        $('.textarea_ltr').ckeditor(textareaLtr);

    </script>
<?php endif; ?>
<?php if(isset($file_upload)): ?>
    <?php echo $__env->make('layouts.script.file_upload', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php if(isset($progress)): ?>
    <script src="<?php echo e(URL::asset('assets/plugins/progress/jquery-asPieProgress.js')); ?>"></script>
   <script>
       jQuery(function($) {
           $('.pie_progress').asPieProgress({
               namespace: 'pie_progress'
           });
       })
       $(document).ready(function () {
           $('.pie_progress').asPieProgress('start');
       })
   </script>
<?php endif; ?>
<script src="<?php echo e(URL::asset('assets/js/custom.js')); ?>"></script>
<script>
    $(".key_word").selectize({
        delimiter: ",,",
        plugins: {
            remove_button: {
                label: "×"
            }
        },
        persist: false,
        createOnBlur: true,
        create: true
    });
    $(".contact_multi").selectize({
        delimiter: ",",
        plugins: {
            remove_button: {
                label: "×"
            }
        },
        persist: false,
        createOnBlur: true,
        create: true,
        copyClassesToDropdown:false
    });
    <?php if(isset($req)): ?>
    $("#form_req").validate({
        submitHandler: function (form) {
            if($('.textarea_rtl')[0] || $('.textarea_ltr')[0])
            {
                for (var i in CKEDITOR.instances) {
                    CKEDITOR.instances[i].updateElement();
                }
            }

            $('#global-loader-form').css('display', 'block');
            form.submit();
        }
    });
    <?php endif; ?>
    <?php if(session()->has('err_message')): ?>
    $(document).ready(function () {
        Swal.fire({
            title: "ناموفق",
            text: "<?php echo e(session('err_message')); ?>",
            icon: "warning",
            timer: 6000,
            timerProgressBar: true,
        })
    });
    <?php endif; ?>
    <?php if(session()->has('flash_message')): ?>
    $(document).ready(function () {
        Swal.fire({
            title: "موفق",
            text: "<?php echo e(session('flash_message')); ?>",
            icon: "success",
            timer: 6000,
            timerProgressBar: true,
        })
    })
    ;<?php endif; ?>
    <?php if(count($errors) > 0): ?>
    $(document).ready(function () {
        Swal.fire({
            title: "ناموفق",
            icon: "warning",
            html:
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<p class="text-right mt-2 ml-5" dir="rtl"> <?php echo e($key+1); ?> : ' +
            '<?php echo e($error); ?>' +
            '</p>' +
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                '<p class="text-right mt-2 ml-5" dir="rtl">' +
            '</p>',
            timer: <?php if(count($errors)>3): ?>parseInt('<?php echo e(count($errors)); ?>') * 1500 <?php else: ?> 6000 <?php endif; ?>,
            timerProgressBar: true,
        })
    });
    <?php endif; ?>
</script>
<?php echo $__env->yieldPushContent('in_tag_script'); ?>
<?php echo $__env->yieldContent('in_tag_script'); ?>

</body>
</html>
<?php /**PATH /Users/rezaghiasi/Projects/carosha/resources/views/layouts/admin.blade.php ENDPATH**/ ?>