<?php $__env->startSection('content'); ?>
<div class="row mt-5">
    <div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo e(route('admin.withdraw.result' , $request->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="approveModalLabel">تأیید برداشت</h5>
                        <input type="hidden" name="type" value="accept">
                    </div>
                    <div class="modal-body">
                        <label for="transaction_code" class="form-label">کد تراکنش بانکی</label>
                        <input type="text" name="transaction_code" id="transaction_code" class="form-control" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary closeModal" id="closeModal" data-bs-dismiss="modal">لغو</button>
                        <button type="submit" class="btn btn-success">تأیید</button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo e(route('admin.withdraw.result' , $request->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="rejectModalLabel">رد درخواست برداشت</h5>
                        <input type="hidden" name="type" value="reject">
                    </div>
                    <div class="modal-body">
                        <label for="reason" class="form-label">علت رد</label>
                        <textarea name="reason" id="reason" class="form-control" rows="3" required></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary closeModal" id="closeModal" data-bs-dismiss="modal">لغو</button>
                        <button type="submit" class="btn btn-danger">رد</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="col-xl-12 col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header  border-0">
                <h4 class="card-title">
                    <?php echo e($title); ?>

                </h4>
            </div>

            <div class="card shadow-sm border-0 rounded-3 mb-4">
                <div class="card-body">
                    <h5 class="card-title">درخواست برداشت شماره #<?php echo e($request->request_number); ?></h5>
                    <p class="text-muted mb-3">کاربر: <strong><?php echo e($request->user->name); ?></strong></p>

                    <ul class="list-group list-group-flush mb-3">
                        <li class="list-group-item">مبلغ: <strong><?php echo e(number_format($request->amount)); ?> تومان</strong></li>
                        <li class="list-group-item">کارمزد: <strong><?php echo e(number_format($request->fee)); ?> تومان</strong></li>
                        <li class="list-group-item">مبلغ خالص: <strong><?php echo e(number_format($request->net_amount)); ?> تومان</strong></li>
                        <li class="list-group-item">نوع تراکنش: <strong><?php echo e($request->method == 'cart' ? 'کارت' : 'شبا'); ?></strong></li>
                        <li class="list-group-item">شماره <?php echo e($request->method == 'cart' ? 'کارت' : 'شبا'); ?>: <strong><?php echo e($request->destination); ?></strong></li>
                        <li class="list-group-item">وضعیت:
                            <span class="badge bg-info text-dark"><?php echo e($request->getStatus()['msg']); ?></span>
                        </li>
                        <li class="list-group-item">تاریخ ثبت: <?php echo e(my_jdate($request->created_at , 'Y-m-d H:i')); ?></li>
                        <?php if($request->status == 'accept'): ?>
                        <li class="list-group-item"> شماره تراکنش: <?php echo e($request->transaction_number); ?></li>
                        <?php endif; ?>
                        <?php if($request->status == 'reject'): ?>
                        <li class="list-group-item">  علت رد: <?php echo e($request->admin_note); ?></li>
                        <?php endif; ?>
                    </ul>

                    <?php if($request->status == 'pending'): ?>
                    <div style="display: flex;gap: 5px;" class="">

                        <button class="btn btn-success" data-bs-toggle="modal" id="acceptReq" data-bs-target="#approveModal">
                            <i class="ti ti-check"></i> تایید
                        </button>

                        <button class="btn btn-danger" id="rejectReq" data-bs-toggle="modal" data-bs-target="#rejectModal">
                            <i class="ti ti-x"></i> رد
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var modal;
    document.getElementById('acceptReq').addEventListener('click' , () => {
        modal = new bootstrap.Modal(document.getElementById('approveModal'));
        modal.show();
    })

    document.getElementById('rejectReq').addEventListener('click' , () => {
        modal = new bootstrap.Modal(document.getElementById('rejectModal'));
        modal.show();
    })

    $('.closeModal').click(function(){
        modal.hide();
    })

    // document.querySelector('closeModal').addEventListener('click', () => {
    //     modal.close()
    // })
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app',['req'=>true,'file_upload'=>true,'editor'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amarsara/public_html/back/source/resources/views/admin/withdrawRequest/show.blade.php ENDPATH**/ ?>