<!--mobile menu start-->
<div class="mobile-menu position-fixed bg-white deep-shadow d-none-print">
  <a href="<?php echo e(route('front.index')); ?>" class="logo-wrapper d-block p-2 rounded-1 text-center"><img src="<?php echo e($logo); ?>" alt="<?php echo e($titleSeo); ?>" class="img-fluid"></a>
  <button class="close-menu position-absolute"><i class="fa-solid fa-xmark"></i></button>

  <nav class="mobile-menu-wrapper">
    <ul>
        <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(read_lang_word('home')); ?></a></li>
        <li class="<?php echo e(count($cats_menu) ? 'has-submenu' : ''); ?>">
            <a>
                <?php echo e(read_lang_word('products')); ?>

            </a>
            <?php if(count($cats_menu)): ?>
                <ul class="submenu-wrapper">
                    <?php $__currentLoopData = $cats_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e(route('front.product.list',$cat_menu->slug)); ?>"><?php echo e(read_lang($cat_menu,'title')); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php endif; ?>
        </li>












        <li><a href="<?php echo e(route('front.blog.list')); ?>"><?php echo e(read_lang_word('blog')); ?></a></li>
        <li>
            <a href="<?php echo e(route('front.about.us','service')); ?>"><?php echo e(read_lang_word('service')); ?></a>
        </li>
        <li>
            <a href="<?php echo e(route('front.about.us')); ?>"><?php echo e(read_lang_word('about')); ?></a>
        </li>
        <li><a href="<?php echo e(route('front.contact.us')); ?>"><?php echo e(read_lang_word('contact')); ?></a></li>
    </ul>
  </nav>
  <div class="contact-info mt-60">
    <h4 class="mb-20"><?php echo e(read_lang_word('contact2')); ?></h4>
    <p><i class="fa fa-map-marker-alt"></i> <?php echo e(read_lang($contact_info,'address')); ?></p>
    <?php if(!blank($contact_info->phone) && explode(',',$contact_info->phone)>0): ?>
    <p dir="ltr">
        <a href="tel:<?php echo e(str_replace([' ','-','_'],'',explode(',',$contact_info->phone)[0])); ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-dark">
            <i class="fa fa-phone"></i> <?php echo e(explode(',',$contact_info->phone)[0]); ?>

        </a>
    </p>
    <?php endif; ?>
      <?php if(!blank($contact_info->email) && explode(',',$contact_info->email)>0): ?>
    <p dir="ltr">
        <a href="mailto:<?php echo e(explode(',',$contact_info->email)[0]); ?>" target="_blank" rel="nofollow noopener noreferrer" class="text-dark">
            <i class="fa-regular fa-envelope"></i> <?php echo e(explode(',',$contact_info->email)[0]); ?>

        </a>
    </p>
    <?php endif; ?>
    <div class="social-contact mt-4">
      <?php if($contact_info->telegram): ?>
       <a href="<?php echo e($contact_info->telegram); ?>" target="_blank" rel="nofollow noopener noreferrer"><i class="fab fa-telegram"></i></a>
      <?php endif; ?>
      <?php if($contact_info->instagram): ?>
        <a href="<?php echo e($contact_info->instagram); ?>" target="_blank" rel="nofollow noopener noreferrer"><i class="fab fa-instagram"></i></a>
      <?php endif; ?>
      <?php if($contact_info->facebook): ?>
        <a href="<?php echo e($contact_info->facebook); ?>" target="_blank" rel="nofollow noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
      <?php endif; ?>
      <?php if($contact_info->twitter): ?>
        <a href="<?php echo e($contact_info->twitter); ?>" target="_blank" rel="nofollow noopener noreferrer"><i class="fab fa-twitter"></i></a>
      <?php endif; ?>
      <?php if($contact_info->whatsapp_group): ?>
        <a href="<?php echo e($contact_info->whatsapp_group); ?>" target="_blank" rel="nofollow noopener noreferrer"><i class="fab fa-whatsapp"></i></a>
      <?php endif; ?>
    </div>
  </div>
</div>
<!--mobile menu end--><?php /**PATH /home/newtest/public_html/source/resources/views/front/layouts/includes_front/mobile_menu.blade.php ENDPATH**/ ?>