<?php $__env->startSection('styles'); ?>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>

<?php
    $cart = session('cart', []);
    $total = 0;

    
    if(isset($cart['education'])) {
        foreach($cart['education'] as $edu) {
            $total += $edu['price'];
        }
    }

   
    if(isset($cart['lessons'])) {
        foreach($cart['lessons'] as $eduLessons) {
            foreach($eduLessons as $lesson) {
                $total += $lesson['price'];
            }
        }
    }
?>

<section class="py-0">

	<div class="container">

		<div class="row">

			<div class="col-12">

				<div class="bg-light p-4 text-center rounded-3">

					<h1 class="m-0 fs-2">سبد خرید</h1>

					<!-- Breadcrumb -->

					<div class="d-flex justify-content-center">

						<nav aria-label="breadcrumb">

							<ol class="breadcrumb breadcrumb-dots mb-0">

								<li class="breadcrumb-item"><a href="#">صفحه اصلی</a></li>

								<li class="breadcrumb-item"><a href="#">صفحات</a></li>

								<li class="breadcrumb-item active" aria-current="page">سبد خرید</li>

							</ol>

						</nav>

					</div>

				</div>

			</div>

		</div>

	</div>

</section>

<!-- =======================

Page Banner END -->



<!-- =======================

Page content START -->

<section class="pt-5">

	<div class="container">

	

		<div class="row g-4 g-sm-5">

			<!-- Main content START -->

			<div class="col-lg-8 mb-4 mb-sm-0">

				<div class="card card-body p-4 shadow">

					<!-- Alert -->

					







					<div class="table-responsive border-0 rounded-3">

                        <!-- Table START -->
                        <table class="table align-middle p-4 mb-0">
                            <tbody class="border-top-0">
                    
                                
                                <?php $__currentLoopData = session('cart.education', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-lg-flex align-items-center">
                                            <div class="w-100px w-md-80px mb-2 mb-md-0">
                                                <img src="<?php echo e($edu['image'] ?? 'assets/images/courses/default.jpg'); ?>" class="rounded" alt="">
                                            </div>
                                            <h6 class="mb-0 ms-lg-3 mt-2 mt-lg-0">
                                                <a href="#"><?php echo e($edu['title']); ?></a>
                                            </h6>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <h5 class="text-success mb-0"><?php echo e(number_format($edu['price'])); ?> تومان</h5>
                                    </td>
                                    <td>
                                        
                                        <a href="<?php echo e(route('front.cart.remove' , ['id' => $edu['id'], 'type' => 'education'])); ?>" class="btn btn-sm btn-danger-soft px-2 mb-0"><i class="fas fa-fw fa-times"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                                
                                <?php $__currentLoopData = session('cart.lessons', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu_id => $lessons): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-lg-flex align-items-center">
                                                <div class="w-100px w-md-80px mb-2 mb-md-0">
                                                    <img src="<?php echo e($lesson['image'] ?? 'assets/images/courses/default.jpg'); ?>" class="rounded" alt="">
                                                </div>
                                                <h6 class="mb-0 ms-lg-3 mt-2 mt-lg-0">
                                                    <a href="#"><?php echo e($lesson['title']); ?></a>
                                                </h6>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <h5 class="text-success mb-0"><?php echo e(number_format($lesson['price'])); ?> تومان</h5>
                                        </td>
                                        <td>
                                            
											<a href="<?php echo e(route('front.cart.remove' , ['id' => $lesson['id'] , 'type' => 'lesson'])); ?>" class="btn btn-sm btn-danger-soft px-2 mb-0"><i class="fas fa-fw fa-times"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                            </tbody>
                        </table>
                    </div>



					<!-- Coupon input and button -->

					<div class="row g-3 mt-2">

						<div class="col-md-6">

							<div class="input-group">

								<input class="form-control form-control " placeholder="">

								<button type="button" class="btn btn-primary">کد تخفیف</button>

							</div>

						</div>

						<!-- Update button -->

						<div class="col-md-6 text-md-end">

							<button class="btn btn-primary mb-0" disabled>اعمال</button>

						</div>

					</div>	

				</div>

			</div>

			<!-- Main content END -->



			<!-- Right sidebar START -->

			<div class="col-lg-4">

				<!-- Card total START -->

				<div class="card card-body p-4 shadow">

					<!-- Title -->

					<h4 class="mb-3 fs-5">صورت حساب</h4>



					<!-- Price and detail -->

					<ul class="list-group list-group-borderless mb-2">

						<li class="list-group-item px-0 d-flex justify-content-between">

							<span class="h6 fw-light mb-0">قیمت</span>

							<span class="h6 fw-light mb-0 fw-bold"><?php echo e(number_format($total)); ?> تومان</span>

						</li>


						<li class="list-group-item px-0 d-flex justify-content-between">

							<span class="h5 mb-0">قیمت نهایی</span>

							<span class="h5 mb-0"><?php echo e(number_format($total)); ?> تومان</span>

						</li>

					</ul>



					<!-- Button -->

					<div class="d-grid">

						<form action="<?php echo e(route('front.cart.checkout')); ?>" method="post">
							<?php echo csrf_field(); ?>
							<button class="btn w-100 btn-lg btn-success">تسویه حساب</button>
						</form>

					</div>



					<!-- Content -->

					<p class="small mb-0 mt-2 text-center">با تکمیل خرید خود، <a href="#"><strong>شرایط و قوانین سایت</strong></a> را خواهید پذیرفت.</p>



				</div>

				<!-- Card total END -->

			</div>

			<!-- Right sidebar END -->



		</div><!-- Row END -->

	</div>

</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amarsara/public_html/back/source/resources/views/front/cart/shoppingCart.blade.php ENDPATH**/ ?>