<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(dir_set()); ?>">
<head>
  <!--required meta tags-->
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

  <title><?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?></title>
  <!--og-->
  <meta property="og:title" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>" />
  <meta property="og:description" content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>
  <meta property="og:site_name" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>" />
  <!--twitter og-->
  <meta name="twitter:title" content="<?php if($seo_set): ?> <?php echo e($titleSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($titleSeo2); ?> <?php endif; ?>"/>
  <meta name="twitter:description"  content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>
  <!--facebook og-->
  <meta name="description" content="<?php if($seo_set): ?> <?php echo e($descriptionSeo); ?> <?php elseif(isset($title) && !blank($title)): ?> <?php echo e($title); ?> <?php else: ?> <?php echo e($descriptionSeo2); ?> <?php endif; ?>"/>

  <meta name="robots" content="<?php echo e($robots); ?>"/>
  <link rel="canonical" href="<?php echo e($canonical); ?>" />

  <?php if(trim($__env->yieldContent('og_img'))): ?>
    <?php echo $__env->yieldContent('og_img'); ?>
  <?php else: ?>
    <meta name="twitter:image" content="<?php echo e($fav_icon); ?>"/>
    <meta property="og:image" content="<?php echo e($fav_icon); ?>"/>
  <?php endif; ?>
  <meta name="author" content="https://adib.com.tr/"/>
  <link rel="alternate" hreflang="<?php echo e(app()->getLocale()); ?>" href="<?php echo e(asset('/')); ?>" />

  <?php if(!blank($schemaSeo)): ?>
    <?php echo $schemaSeo; ?>

  <?php endif; ?>

  <link rel="icon" href="<?php echo e($fav_icon); ?>" sizes="16x16"/>

  <meta name="base_url" content="<?php echo e(url('')); ?>">

  <!--build:css-->
  <link rel="stylesheet" href="<?php echo e(url('assets/front/css/main.css?v=1.1.51')); ?>"/>
  <!--custom css-->
  <link rel="stylesheet" href="<?php echo e(url('assets/front/css/custom.css?v=1.1.47')); ?>"/>
  <?php if(dir_set()=='rtl'): ?>
    <link rel="stylesheet" href="<?php echo e(url('assets/front/css/rtl.css?v=1.1.5')); ?>"/>
  <?php endif; ?>
  <?php if(font_farsi()=='yes'): ?>
    <style>
        h1, h2, h3, h4, h5, h6, p, strong, span, input, select, textarea, optgroup, button, li, a, small, label, td, th, div {
            font-family: iranyekan, sans-serif !important;
        }

        p, strong, span, input, select, textarea, optgroup, button, li, a, label, td, th, div {
            font-size: 14px;
        }
    </style>
  <?php endif; ?>
  <style>
    .rent-header-info::after
    {
      display: none;
    }
      .modal-body .at-search-box {
          padding: 0;
      }

      .modal-body .pt-mobile-15px {
          padding-top: 15px;
      }

      .modal-body .w-mobile-100 {
          width: 100%;
      }

      .modal-body .ms-2 {
          margin-left: 0 !important;
      }
  </style>
<?php echo $__env->yieldContent('styles'); ?>
</head>
<body>
<!--main content wrapper start-->
<div class="main-wrapper">

  <?php echo $__env->make('front.layouts.includes_front.header_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->make('front.layouts.includes_front.mobile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->make('front.layouts.includes_front.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->yieldContent('body'); ?>

  <?php echo $__env->make('front.layouts.includes_front.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>

<!--scrolltop button-->
<button class="theme-scrolltop-btn d-none-print"><i class="fa-regular fa-hand-pointer"></i></button>
<!--scrolltop button end-->

<!--build:js-->
<script src="<?php echo e(asset('assets/front/js/vendors/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/vendors/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/vendors/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/vendors/swiper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/app.js?v=1.1.9')); ?>"></script>
<!--endbuild-->
<!-- sweetalert2 js-->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
  <?php if(session()->has('err_message')): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
          text: "<?php echo e(session('err_message')); ?>",
          icon: "warning",
          timer: 6000,
          timerProgressBar: true,
      })
  });
  <?php endif; ?>
  <?php if(session()->has('flash_message')): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('successful')); ?>",
          text: "<?php echo e(session('flash_message')); ?>",
          icon: "success",
          timer: 6000,
          timerProgressBar: true,
      })
  })
  ;<?php endif; ?>
  <?php if(count($errors) > 0): ?>
  $(document).ready(function () {
      Swal.fire({
          title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
          icon: "warning",
          html:
                  <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      '<p class="text-right mt-2 ml-5" dir="rtl"> <?php echo e($key+1); ?> : ' +
              '<?php echo e($error); ?>' +
              '</p>' +
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      '<p class="text-right mt-2 ml-5" dir="rtl">' +
              '</p>',
          timer: <?php if(count($errors)>3): ?>parseInt('<?php echo e(count($errors)); ?>') * 1500 <?php else: ?> 6000 <?php endif; ?>,
          timerProgressBar: true,
      })
  });
  <?php endif; ?>
</script>
<?php echo $__env->yieldContent('scripts'); ?>
<?php if($contact_info->whatsapp2): ?>
  <div class="wat_sapp wat_sapp1 d-none-print">
    <a target="_blank" rel="nofollow noopener noreferrer" href="<?php echo e($contact_info->whatsapp2); ?>">
      <img class="social_img" src="<?php echo e(asset('assets/front/img/whatss.png')); ?>" alt="...">
    </a>
  </div>
<?php endif; ?>

</body>
</html>
<?php /**PATH /home/etakon/public_html/source/resources/views/front/layouts/front.blade.php ENDPATH**/ ?>