<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.js"></script>

<script>
    $(document).ready(function () {
        jQuery.extend(jQuery.validator.messages, {
            required: "<?php echo e(read_lang_word('req-required')); ?>",
            remote: "<?php echo e(read_lang_word('req-remote')); ?>",
            email: "<?php echo e(read_lang_word('req-email')); ?>",
            url: "<?php echo e(read_lang_word('req-url')); ?>",
            date: "<?php echo e(read_lang_word('req-date')); ?>",
            dateISO: "<?php echo e(read_lang_word('req-date-iso')); ?>",
            number: "<?php echo e(read_lang_word('req-digits')); ?>",
            digits: "<?php echo e(read_lang_word('req-digits')); ?>",
            creditcard: "<?php echo e(read_lang_word('	req-credit-card')); ?>",
            equalTo: "<?php echo e(read_lang_word('req-equal-to')); ?>",
            accept: "<?php echo e(read_lang_word('req-accept')); ?>",
            maxlength: jQuery.validator.format("<?php echo e(read_lang_word('req-max-length')); ?>{0}"),
            minlength: jQuery.validator.format("<?php echo e(read_lang_word('req-min-length')); ?>{0}"),
            rangelength: jQuery.validator.format("<?php echo e(read_lang_word('req-rang-elength')); ?>{0},{1}"),
            range: jQuery.validator.format("<?php echo e(read_lang_word('req-range')); ?>{0},{1}"),
            max: jQuery.validator.format("<?php echo e(read_lang_word('req-max')); ?>{0}"),
            min: jQuery.validator.format("<?php echo e(read_lang_word('req-min')); ?>{0}")
        });

    });


    $("#form_req").validate({
        submitHandler: function (form) {
            $('.ring-preloader').css('display', 'flex')
            form.submit();
        }
    });
    $("#form_req1").validate({
        submitHandler: function (form) {
            $('.ring-preloader').css('display', 'flex')
            form.submit();
        }
    });
    $("#CarMessageModalForm").validate({
         submitHandler: function (form) {
              $('.ring-preloader').css('display', 'flex')
              form.submit();
         }
    });
    $("#form_req_search_form").validate({
         submitHandler: function (form) {
             $.ajax({
                 url: form.action,
                 type: form.method,
                 data: $(form).serialize(),
                 success: function(data) {
                     if(data.status==0)
                     {
                         Swal.fire({
                             title:"<?php echo e(read_lang_word('unsuccessful')); ?>",
                             text: data.message,
                             icon: "warning",
                             timer: 6000,
                             timerProgressBar: true,
                         })
                     }
                     else
                     {
                         Swal.fire({
                             title:"<?php echo e(read_lang_word('successful')); ?>",
                             text: data.message,
                             icon: "success",
                             timer: 6000,
                             timerProgressBar: true,
                         })
                         $('#form_req_search_form .border').val('');
                     }
                 },
                 error: function(jqXhr, json, errorThrown) {
                     var errors = jqXhr.responseJSON;
                     var errorsHtml = '';
                     $.each(errors['errors'], function (index, value) {
                         errorsHtml += '<ul class="list-group"><li class="list-group-item text-dark">' + value + '</li></ul>';
                     });
                     Swal.fire({
                         title: "<?php echo e(read_lang_word('unsuccessful')); ?>",
                         icon: "warning",
                         html:errorsHtml,
                         timer: <?php if(count($errors)>3): ?>parseInt('<?php echo e(count($errors)); ?>') * 1500 <?php else: ?> 6000 <?php endif; ?>,
                         timerProgressBar: true,
                     })
                 }
             });
         }
    });
</script><?php /**PATH /home/magma/public_html/source/resources/views/front/includes/req.blade.php ENDPATH**/ ?>