<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<!--blog section start-->

<section class="blog-section pt-70 pb-70">

    <div class="container">

        <div class="row g-4 justify-content-center">

            <div class="d-flex justify-content-between">
                <h4 class="mb-4">لیست درخواست‌های برداشت</h4>
                <a href="<?php echo e(route('front.withdraw-request.create')); ?>" class="btn btn-outline-info">ایجاد درخواست</a>
            </div>

            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $withdrawRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h6 class="fw-bold mb-0">مبلغ: <?php echo e(number_format($request->amount)); ?> تومان</h6>
                                <?php switch($request->status):
                                case ('pending'): ?>
                                <span class="badge bg-warning text-dark">در انتظار بررسی</span>
                                <?php break; ?>
                                <?php case ('accept'): ?>
                                <span class="badge bg-success">تأیید شده</span>
                                <?php break; ?>
                                <?php case ('reject'): ?>
                                <span class="badge bg-danger">رد شده</span>
                                <?php break; ?>
                                <?php endswitch; ?>
                            </div>

                            <p class="mb-1 text-muted">کارمزد: <?php echo e(number_format($request->fee)); ?> تومان</p>
                            <p class="mb-1 text-muted">خالص دریافتی: <?php echo e(number_format($request->amount - $request->fee)); ?> تومان</p>
                            <p class="mb-1"><i class="ti ti-calendar"></i> <?php echo e(my_jdate($request->created_at , 'Y-m-d H:i:s')); ?></p>

                            <?php if($request->description): ?>
                            <p class="mt-2 small text-secondary border-top pt-2">توضیحات: <?php echo e($request->description); ?></p>
                            <?php endif; ?>

                            <?php if($request->status == 'accept'): ?>
                            <p class="mt-2 small text-secondary border-top pt-2">شماره تراکنش: <?php echo e($request->transaction_number); ?></p>
                            <?php endif; ?>

                            <?php if($request->status == 'reject'): ?>
                            <p class="mt-2 small text-secondary border-top pt-2"> علت رد: <?php echo e($request->admin_note); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <div class="alert alert-info">هیچ درخواست برداشتی ثبت نشده است.</div>
                </div>
                <?php endif; ?>
            </div>`

        </div>

    </div>

</section>

<!--blog section end-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amarsara/public_html/back/source/resources/views/front/withdraw_request/index.blade.php ENDPATH**/ ?>