
<?php $__env->startSection('styles'); ?>
  <style>
    iframe
    {
      width: 100%!important;
      height: 400px;
      box-shadow: 0 0 2px 0 #66666690;
      border-radius: 5px;
      overflow: hidden;
      padding: 10px;
    }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <section class="contact-section ptb-5">
        <div class="container">
            <div class="row">
                <div class="col-xl-8">
                    <div class="contact-form-area bg-white rounded">
                        <h4 class="mb-3"><?php echo e(read_lang($item,'title')); ?></h4>
                        <hr/>
                        <form action="<?php echo e(route('front.contact.us.post')); ?>" class="ct-form-wrapper mt-3" method="post" id="form_req_search_form">
                            <?php echo csrf_field(); ?>
                            <input hidden name="type" value="contact">
                            <div class="row g-4">
                                <div class="col-sm-6">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1">* <?php echo e(read_lang_word('name')); ?></label>
                                        <input type="text" placeholder="<?php echo e(read_lang_word('name')); ?>" name="name" value="<?php echo e(old('name')); ?>" class="border w-100 rounded" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1"><?php echo e(read_lang_word('email')); ?></label>
                                        <input type="email" placeholder="<?php echo e(read_lang_word('email')); ?>" name="email" value="<?php echo e(old('email')); ?>" class="border w-100 rounded text-start" dir="ltr">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1"><?php echo e(read_lang_word('phone')); ?></label>
                                        <input type="tel" placeholder="<?php echo e(read_lang_word('phone')); ?>" name="phone" value="<?php echo e(old('phone')); ?>" inputmode="numeric" class="border w-100 rounded text-start" dir="ltr">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1">* <?php echo e(read_lang_word('issue')); ?> </label>
                                        <input type="text" placeholder="<?php echo e(read_lang_word('issue')); ?>" name="subject" value="<?php echo e(old('subject')); ?>" class="border w-100 rounded" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1">* <?php echo e(read_lang_word('msg-text')); ?> </label>
                                        <textarea placeholder="<?php echo e(read_lang_word('msg-text')); ?>" class="border w-100 rounded" name="message" rows="5" required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-sm-8 mx-auto">
                                    <div class="input-field">
                                        <label class="fw-semibold text-secondary mb-1">* <?php echo e(read_lang_word('captcha')); ?> </label>
                                        <img src="<?php echo e(captcha()); ?>" class="m-auto captcha_img d-block" width="80">
                                        <input type="number" placeholder="<?php echo e(read_lang_word('captcha')); ?>" name="captcha" value="" class="border captcha_input w-100 rounded text-center" required>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <button class="btn btn-primary btn-md mt-4" type="submit"><?php echo e(read_lang_word('submit-form')); ?></button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>
                <div class="col-xl-4">
                        <div class="contact-sidebar-widget py-5 px-4 bg-white rounded mt-3 mt-xl-0">
                            <h4 class="mb-4"><?php echo e(read_lang_word('r_title')); ?></h4>
                            <ul class="fs-md">
                                <li class="fw-500"><strong class="fw-bold text-secondary"><?php echo e(read_lang_word('address')); ?>: </strong><?php echo e(read_lang($item,'address')); ?></li>
                              
                          
                            </ul>

                            <ul class="fs-md mt-3">
                            
                                <li class="fw-500"><strong class="fw-bold text-secondary mt-5"><?php echo e(read_lang_word('address2')); ?>: </strong><?php echo e(read_lang($item,'address2')); ?></li>
                          
                            </ul>
                            <hr class="mt-4 mb-4">

                            <ul class="contact-info">
                                <?php if(!blank($item->phone) && count(explode(',',$item->phone))): ?>
                                    <?php $__currentLoopData = explode(',',$item->phone); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="d-flex align-items-center  mt-0">
                                            <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i class="fa fa-phone"></i></span>
                                            <div class="<?php echo e(dir_set()=='ltr'?'ms-3':'me-3'); ?> info-content">
                                                <a href="tel:<?php echo e(str_replace([' ','+','-','(',')'],'',$phone)); ?>" dir="ltr"><?php echo e($phone); ?></a>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if(!blank($item->mobile) && count(explode(',',$item->mobile))): ?>
                                    <?php $__currentLoopData = explode(',',$item->mobile); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$mobile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($key == 0): ?>
                                            <li class="d-flex align-items-center  mt-0">
                                                <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i class="fa fa-mobile"></i></span>
                                                <div class="<?php echo e(dir_set()=='ltr'?'ms-3':'me-3'); ?> info-content">
                                                    <a href="tel:<?php echo e(str_replace([' ','+','-','(',')'],'',$mobile)); ?>" dir="ltr"><?php echo e($mobile); ?></a>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if(!blank($item->fax) && count(explode(',',$item->fax))): ?>
                                    <?php $__currentLoopData = explode(',',$item->fax); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$fax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="d-flex align-items-center  mt-0">
                                            <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i class="fa fa-fax"></i></span>
                                            <div class="<?php echo e(dir_set()=='ltr'?'ms-3':'me-3'); ?> info-content">
                                                <a href="tel:<?php echo e(str_replace([' ','+','-','(',')'],'',$fax)); ?>" dir="ltr"><?php echo e($fax); ?></a>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if(!blank($item->whatsapp) && count(explode(',',$item->whatsapp))): ?>
                                    <?php $__currentLoopData = explode(',',$item->whatsapp); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$whatsapp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="d-flex align-items-center  mt-0">
                                            <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i class="fa-brands fa-whatsapp"></i></span>
                                            <div class="<?php echo e(dir_set()=='ltr'?'ms-3':'me-3'); ?> info-content">
                                                <a href="https://api.whatsapp.com/send?phone=+<?php echo e(str_replace([' ','+','-','(',')'],'',$whatsapp)); ?>" dir="ltr"><?php echo e($whatsapp); ?></a>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if(!blank($item->email) && count(explode(',',$item->email))): ?>
                                    <?php $__currentLoopData = explode(',',$item->email); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="d-flex align-items-center mt-0">
                                            <span class="icon-wrapper d-flex align-items-center justify-content-center rounded bg-light-primary rounded-circle flex-shrink-0"><i class="fa-regular fa-envelope"></i></span>
                                            <div class="<?php echo e(dir_set()=='ltr'?'ms-3':'me-3'); ?> info-content">
                                                <a href="mailto:<?php echo e(str_replace([' ','+','-','(',')'],'',$email)); ?>" dir="ltr"><?php echo e($email); ?></a>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </ul>
                            <?php if($item->telegram || $item->instagram || $item->facebook || $item->twitter || $item->youtube || $item->linkedin || $item->aparat || $item->whatsapp_group): ?>
                                <hr class="mt-30 mb-40">
                                <h6 class="mb-3"><?php echo e(read_lang_word('social')); ?></h6>
                                <div class="contact-social">
                                    <?php if($item->telegram): ?>
                                        <a href="<?php echo e($item->telegram); ?>"><i class="fab fa-telegram"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->instagram): ?>
                                        <a href="<?php echo e($item->instagram); ?>"><i class="fab fa-instagram"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->facebook): ?>
                                        <a href="<?php echo e($item->facebook); ?>"><i class="fab fa-facebook-f"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->twitter): ?>
                                        <a href="<?php echo e($item->twitter); ?>"><i class="fab fa-twitter"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->linkedin): ?>
                                        <a href="<?php echo e($item->linkedin); ?>"><i class="fab fa-linkedin"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->youtube): ?>
                                        <a href="<?php echo e($item->youtube); ?>"><i class="fab fa-youtube"></i></a>
                                    <?php endif; ?>
                                    <?php if($item->aparat): ?>
                                        <a href="<?php echo e($item->aparat); ?>"><?php echo logo_aparat(); ?></a>
                                    <?php endif; ?>
                                    <?php if($item->whatsapp_group): ?>
                                        <a href="<?php echo e($item->whatsapp_group); ?>"><i class="fab fa-whatsapp"></i></a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                </div>

            </div>
        </div>
        <?php if(!blank($item->address_iframe)): ?>
            <div class="col-12 py-2">
                <?php echo $item->address_iframe; ?>

            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <?php echo $__env->make('front.includes.req', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/etakon/public_html/source/resources/views/front/contact.blade.php ENDPATH**/ ?>