<?php

use App\Http\Controllers\Front\Cart\CartController;
use App\Http\Controllers\Front\Education\EducationsController;
use App\Http\Controllers\Front\Financial\CheckoutController;
use App\Http\Controllers\Front\Financial\WithdrawRequestController;
use App\Http\Controllers\Front\HomeController;
use Illuminate\Support\Facades\Route;


// index
Route::get('/', [HomeController::class, 'index'])->name('index');

// about us
Route::get('/about-us/{slug?}', [HomeController::class, 'about'])->name('about.us');
//Route::get('/certificate', [HomeController::class, 'certificate'])->name('certificate');
// about us
Route::get('/faqs', [HomeController::class, 'faq'])->name('faq');


// contact us
Route::get('/contact-us', [HomeController::class, 'contact'])->name('contact.us');
Route::post('/contact-us/post', [HomeController::class, 'contact_post'])->name('contact.us.post');

Route::post('/comment/post', [HomeController::class, 'comment_post'])->name('comment.post');

//blogs
Route::get('/blogs', [HomeController::class, 'blog_list'])->name('blog.list');
Route::get('/blogs/{slug}', [HomeController::class, 'blog_show'])->name('blog.show');
Route::get('/tags/{slug}', [HomeController::class, 'tag_show'])->name('tag.show');


//products
Route::get('/products/{cat_slug?}', [HomeController::class, 'product_list'])->name('product.list');
Route::get('/product/{slug}', [HomeController::class, 'product_show'])->name('product.show');

Route::get('/education-categories', [EducationsController::class, 'categories'])->name('education.categories');
Route::get('/educations', [EducationsController::class, 'educations'])->name('education.index');
Route::get('/education/{id}', [EducationsController::class, 'education'])->name('education.single');
Route::get('/education/episodes/{id}', [EducationsController::class, 'lesson'])->name('education.episode.single');

Route::get('add-to-cart/{id}/{type}', [CartController::class, 'addToCart'])->name('cart.add');
Route::get('remove-from-cart/{id}/{type}', [CartController::class, 'RemoveFromCart'])->name('cart.remove');
Route::get('cart', [CartController::class, 'cart'])->name('cart.index');

Route::post('checkout', [CheckoutController::class, 'checkout'])->name('cart.checkout')->middleware('auth');

Route::get('/encyclopedia', [HomeController::class, 'encyclopedia_list'])->name('encyclopedia.list');
Route::get('/encyclopedia/{slug}', [HomeController::class, 'encyclopedia_show'])->name('encyclopedia.show');


Route::get('/rules', [HomeController::class, 'rules'])->name('rules');

Route::resource('withdraw-request', WithdrawRequestController::class);

//services
//Route::get('/services', [HomeController::class, 'service_list'])->name('service.list');

// gallery image&video
//Route::get('/gallery', [HomeController::class, 'gallery'])->name('gallery');

