@extends('front.layouts.front')

@section('styles')
@endsection

@section('body')
<!--blog section start-->

<section class="blog-section pt-70 pb-70">

    <div class="container">

        <div class="row g-4 justify-content-center">

            <div class="d-flex justify-content-between">
                <h4 class="mb-4">لیست درخواست‌های برداشت</h4>
                <a href="{{route('front.withdraw-request.create')}}" class="btn btn-outline-info">ایجاد درخواست</a>
            </div>

            <div class="row">
                @forelse ($withdrawRequests as $request)
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h6 class="fw-bold mb-0">مبلغ: {{ number_format($request->amount) }} تومان</h6>
                                @switch($request->status)
                                @case('pending')
                                <span class="badge bg-warning text-dark">در انتظار بررسی</span>
                                @break
                                @case('accept')
                                <span class="badge bg-success">تأیید شده</span>
                                @break
                                @case('reject')
                                <span class="badge bg-danger">رد شده</span>
                                @break
                                @endswitch
                            </div>

                            <p class="mb-1 text-muted">کارمزد: {{ number_format($request->fee) }} تومان</p>
                            <p class="mb-1 text-muted">خالص دریافتی: {{ number_format($request->amount - $request->fee) }} تومان</p>
                            <p class="mb-1"><i class="ti ti-calendar"></i> {{ my_jdate($request->created_at , 'Y-m-d H:i:s') }}</p>

                            @if($request->description)
                            <p class="mt-2 small text-secondary border-top pt-2">توضیحات: {{ $request->description }}</p>
                            @endif

                            @if($request->status == 'accept')
                            <p class="mt-2 small text-secondary border-top pt-2">شماره تراکنش: {{ $request->transaction_number }}</p>
                            @endif

                            @if($request->status == 'reject')
                            <p class="mt-2 small text-secondary border-top pt-2"> علت رد: {{ $request->admin_note }}</p>
                            @endif
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-12">
                    <div class="alert alert-info">هیچ درخواست برداشتی ثبت نشده است.</div>
                </div>
                @endforelse
            </div>`

        </div>

    </div>

</section>

<!--blog section end-->
@endsection

@section('scripts')

@endsection