@extends('front.layouts.front')

@section('styles')
<style>
    .form-select option{
        direction: rtl !important;
        unicode-bidi: plaintext;
        text-align: right;
    }
</style>
@endsection

@section('body')


    <section class="blog-section pt-70 pb-70">

        <div class="container">

            <div class="row g-4 justify-content-center">

              
                <div class="card shadow-sm border-0 rounded-3">
                    <div class="card-body p-4">

                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div>
                                <h5 class="card-title mb-0">درخواست برداشت</h5>
                                <div class="text-muted small">از کیف پول خود برداشت کنید</div>
                            </div>

                            <div class="text-end">
                                <span class="badge bg-info rounded-pill">وضعیت حساب: <strong
                                        class="ms-1 text-dark">فعال</strong></span>
                            </div>
                        </div>

                
                        <div class="mb-3">
                            <div class="bg-light border rounded-2 p-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="small text-muted">موجودی قابل برداشت</div>
                                    <div class="h5 fw-bold mt-1" id="balanceDisplay" role="button" style="cursor:pointer;"
                                        title="برای قرار دادن کل موجودی در فیلد، کلیک کنید">
                              
                                        {{ number_format(auth()->user()->balance()) }} <small
                                            class="text-muted">تومان</small>
                                    </div>
                                    <div class="small text-muted">برای استفادهٔ کامل روی عدد کلیک کنید</div>
                                </div>

                                <div class="text-center">
                                    <i class="bi bi-wallet2" style="font-size:28px;"></i>
                                </div>
                            </div>
                        </div>

             
                        <form id="withdrawForm" method="POST" action="{{route('front.withdraw-request.store')}}">
                            @csrf

                            <div class="row g-3">
                               
                                <div class="col-12">
                                    <label for="amount" class="form-label">مقدار برداشت (تومان)</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="amount" name="amount"
                                            min="1000" step="100" placeholder="مثلاً 50000" required>
                                        <span class="input-group-text">تومان</span>
                                    </div>
                                    <div class="form-text text-muted">حداقل برداشت: <span id="minAmountText">1,000</span>
                                        تومان</div>
                                </div>

                             
                                <div class="col-md-6">
                                    <label for="method" class="form-label">روش پرداخت</label>
                                    <select style="direction: rtl; text-align: right" id="method" name="method" class="form-select" required>
                                        <option value="cart">کارت بانکی</option>
                                        <option value="sheba">شماره شبا بانکی</option>
                                    </select>
                                </div>

                          
                                <div class="col-md-6">
                                    <label for="destination" class="form-label">شماره / آدرس مقصد</label>
                                    <input type="text" id="destination" name="destination" class="form-control"
                                        placeholder="مثلاً 621986...." required>
                                    <div class="form-text text-muted">شماره کارت یا شبا یا آدرس کیف پول را وارد کنید.</div>
                                </div>

                              
                                <div class="col-12">
                                    <label for="note" class="form-label">توضیحات (اختیاری)</label>
                                    <textarea id="note" name="note" rows="3" class="form-control"
                                        placeholder="دلیل برداشت یا توضیح برای مدیر"></textarea>
                                </div>

                                <div class="col-12">
                                    <div
                                        class="d-flex justify-content-between align-items-center p-3 border rounded-2 bg-white">
                                        <div>
                                            <div class="small text-muted">کارمزد تقریبی</div>
                                            <div id="feeText" class="fw-bold text-danger">0 تومان</div>
                                        </div>
                                        <div class="text-end">
                                            <div class="small text-muted">مقدار دریافتی شما</div>
                                            <div id="netText" class="fw-bold text-success">0 تومان</div>
                                        </div>
                                    </div>
                                    <div class="form-text text-muted mt-2">کارمزد پیش‌فرض: <strong
                                            id="feePercent">1.5%</strong> + ثابت <strong id="feeFixed">1000 تومان</strong>
                                        (قابل تغییر در سرور)</div>
                                </div>

                          
                                <div class="col-12">
                                    <div id="formAlert" class="alert d-none" role="alert"></div>
                                </div>

                            
                                <div class="col-12 d-flex justify-content-end">
                                    <button type="button" id="btnPreview"
                                        class="btn btn-outline-secondary me-2">پیش‌نمایش</button>
                                    <button type="button" id="btnSubmit" class="btn btn-primary">ارسال درخواست</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

        </div>

    </section>

    <div class="modal fade" id="confirmWithdrawModal" tabindex="-1" aria-hidden="true" dir="rtl">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <h5 class="mb-3">تأیید نهایی برداشت</h5>

                    <div class="mb-2"><small class="text-muted">مقدار برداشت</small>
                        <div id="confirmAmount" class="fw-bold fs-5"></div>
                    </div>
                    <div class="mb-2"><small class="text-muted">کارمزد</small>
                        <div id="confirmFee" class="fw-bold text-danger"></div>
                    </div>
                    <div class="mb-2"><small class="text-muted">مقدار قابل دریافت</small>
                        <div id="confirmNet" class="fw-bold text-success"></div>
                    </div>
                    <div class="mb-2"><small class="text-muted">روش دریافت</small>
                        <div id="confirmMethod" class="fw-bold"></div>
                    </div>
                    <div class="mb-2"><small class="text-muted">مقصد</small>
                        <div id="confirmDestination" class="fw-bold text-truncate"></div>
                    </div>

                    <div class="d-flex justify-content-end mt-3 gap-2">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">لغو</button>
                        <button id="confirmSend" type="button" class="btn btn-primary">تأیید و ارسال</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            
            const balance = Number(@json(auth()->user()->balance())); 
            const minAmount = 1000; 
            const feePercent = 1.5; 
            const feeFixed = 1000; 

           
            const balanceDisplay = document.getElementById('balanceDisplay');
            const amountInput = document.getElementById('amount');
            const methodSelect = document.getElementById('method');
            const destinationInput = document.getElementById('destination');
            const feeText = document.getElementById('feeText');
            const netText = document.getElementById('netText');
            const btnPreview = document.getElementById('btnPreview');
            const btnSubmit = document.getElementById('btnSubmit');
            const formAlert = document.getElementById('formAlert');
            const confirmModalEl = document.getElementById('confirmWithdrawModal');
            const confirmModal = new bootstrap.Modal(confirmModalEl);
            const confirmAmount = document.getElementById('confirmAmount');
            const confirmFee = document.getElementById('confirmFee');
            const confirmNet = document.getElementById('confirmNet');
            const confirmMethod = document.getElementById('confirmMethod');
            const confirmDestination = document.getElementById('confirmDestination');
            const confirmSend = document.getElementById('confirmSend');

          
            function fmt(n) {
                if (isNaN(n)) return '0';
                return n.toLocaleString('fa-IR');
            }

            balanceDisplay.addEventListener('click', function() {
                amountInput.value = balance;
                updateFeeAndNet();
            });

           
            function updateFeeAndNet() {
                const amount = Number(amountInput.value) || 0;
                if (amount <= 0) {
                    feeText.textContent = '0 تومان';
                    netText.textContent = '0 تومان';
                    return;
                }
                const fee = Math.round(amount * 0.10);
                const net = Math.max(0, amount - fee);

                feeText.textContent = fmt(fee) + ' تومان';
                netText.textContent = fmt(net) + ' تومان';
                document.getElementById('feeFixed').textContent = feeFixed.toLocaleString('fa-IR') + ' تومان';
            }


            amountInput.addEventListener('input', updateFeeAndNet);
            methodSelect.addEventListener('change', function() {
                const method = methodSelect.value;
                destinationInput.placeholder = method === 'sheba' ? 'IR820540102680020817909002' : (
                    method === 'card' ? '6219 86XX XXXX XXXX' : 'آدرس کیف پول');
            });

          
            btnPreview.addEventListener('click', function() {
                formAlert.classList.add('d-none');
                
                const amount = Number(amountInput.value);
                const dest = destinationInput.value.trim();

                if (!amount || amount < minAmount) {
                    showError('لطفاً یک مبلغ معتبر وارد کنید (حداقل ' + fmt(minAmount) + ' تومان).');
                    return;
                }
                if (amount > balance) {
                    showError('مبلغ وارد شده از موجودی شما بیشتر است.');
                    return;
                }
                if (!dest) {
                    showError('مقصد برداشت را وارد کنید (شماره کارت/شبا/آدرس کیف پول).');
                    return;
                }

                updateFeeAndNet();

        
                confirmAmount.textContent = fmt(amount) + ' تومان';
                confirmFee.textContent = feeText.textContent;
                confirmNet.textContent = netText.textContent;
                confirmMethod.textContent = (methodSelect.value === 'card' ? 'کارت بانکی' : (methodSelect
                    .value === 'sheba' ? 'شبا' : 'کیف پول'));
                confirmDestination.textContent = dest;

                confirmModal.show();
            });

           
            confirmSend.addEventListener('click', function() {
         
                confirmSend.disabled = true;
                confirmSend.textContent = 'در حال ارسال...';

               
                const amount = Number(amountInput.value);
                if (!amount || amount < minAmount || amount > balance) {
                    showError('خطا در مقدار قبل از ارسال.');
                    confirmSend.disabled = false;
                    confirmSend.textContent = 'تأیید و ارسال';
                    return;
                }


                document.getElementById('withdrawForm').submit();
            });

    
            btnSubmit.addEventListener('click', function() {
                btnPreview.click();
            });

            function showError(msg) {
                formAlert.classList.remove('d-none', 'alert-success');
                formAlert.classList.add('alert-danger');
                formAlert.innerHTML = msg;
            }

          
            document.getElementById('minAmountText').textContent = fmt(minAmount) + ' تومان';
            updateFeeAndNet();

        });
    </script>
@endsection
