@extends('front.layouts.front')
@section('styles') @endsection
@section('body')
    @if(count($blogs))
        <!--blog section start-->
        <section class="about-section pt-60 pb-120 bg-primary-light position-relative z-1 overflow-hidden"
                 data-background="{{url('assets/front/img/shapes/about-bg.jpg')}}">
            <img src="{{url('assets/front/img/shapes/tire-primary-light.png')}}" alt="tire"
                 class="tire-primary-light position-absolute end-0 top-0 z--1">
            <span class="small-circle-shape position-absolute z--1"></span>
            <div class="container">
                <div class="blog-card-wrapper mt-5">
                    <div class="row g-4 justify-content-center">
                        @foreach($blogs as $item)
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10 px-1">
                                @include('front.blog.includes.card',['item'=>$item])
                            </div>
                        @endforeach
                        <div class="col-12 mt-5 paginate-div text-center">
                            {{$blogs->appends(Request::except('page'))->links("pagination::bootstrap-4")}}
                        </div>
                    </div>
                    <div class="row g-4 justify-content-center mt-3">
                        <div class="col-12 editor-text">
                            {!! read_lang($item, 'text') !!}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--blog section end-->
    @endif
@endsection
@section('scripts') @endsection
