@extends('front.layouts.front')
@if(!blank($item->photo && is_file($item->photo->path)))
    @section('title_seo')
        <meta name="twitter:image" content="{{url($item->photo->path)}}"/>
        <meta property="og:image" content="{{url($item->photo->path)}}"/>
    @endsection
@endif
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}"/>
@endsection
@section('body')
    <!--blog list section start-->
    <section class="blog-list-section ptb-60">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-7 mb-md-0 mb-4 order-1">
                    <div class="p-3 card mb-3 text-justify d-md-none">
                        {{read_lang($item,'top_text')}}
                    </div>
                    <div class="product_view_slider d-flex">
                        <div class="product_thumb_slider_2 px-1 swiper">
                            <div class="swiper-wrapper">
                                @if(count($item->gallery_mobile) && isMobile())
                                    @foreach($item->gallery_mobile as $gallery)
                                        <div class="swiper-slide pb-2">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @else
                                    @foreach($item->gallery as $gallery)
                                        <div class="swiper-slide pb-2">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div class="product_feature_img_slider_2 swiper">
                            <div class="swiper-wrapper">
                                @if(count($item->gallery_mobile) && isMobile())
                                    @foreach($item->gallery_mobile as $gallery)
                                        <div class="swiper-slide" data-fancybox="gallery"
                                             href="{{url($gallery->path)}}">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @else
                                    @foreach($item->gallery as $gallery)
                                        <div class="swiper-slide" data-fancybox="gallery"
                                             href="{{url($gallery->path)}}">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="flash-controls flash1-button-prev flash-button-prev"><i
                                        class="fa-solid fa-angle-left"></i>
                            </div>
                            <div class="flash-controls flash1-button-next flash-button-next"><i
                                        class="fa-solid fa-angle-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-5 order-md-4 order-5">
                    <div class="card">
                        <div class="p-3 text-justify d-md-block d-none">
                            {{read_lang($item,'top_text')}}
                        </div>
                        <table class="table table-striped w-100 mb-0">
                            <tbody>
                            @foreach($item->attrs_active as $attr)
                                <tr>
                                    <td>{{read_lang($attr,'title')}}</td>
                                    <td>{{read_lang($attr,'value')}}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row mt-3">
                @foreach($item->attrs_icon_active as $attr)
                    @if(is_file($attr->title))
                        <div class="col-md-3 p-1 mx-auto col-6">
                            <div class="card-attr text-center p-3">
                                <img src="{{url($attr->title)}}" alt="{{read_lang($attr,'value')}}">
                                <div class="mt-2">
                                    {{read_lang($attr,'value')}}
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="container-fluid mt-3 product_tab_sticky">
                <div class="row justify-content-center {{!blank(strip_tags(read_lang($item,'text2'))) &&  count($products) ? 'min-w-600' : 'min-w-400'}}">
                    <div class="col-4">
                        <button class="btn btn-primary w-100" id="text_btn">
                            {{read_lang_word('product-description')}}
                        </button>
                    </div>
                    @if(!blank(read_lang($item,'text2')))
                        <div class="col-4">
                            <button class="btn btn-primary w-100" id="text2_btn">
                                {{read_lang_word('product-info')}}
                            </button>
                        </div>
                    @endif
                    @if(count($products))
                        <div class="col-4">
                            <button class="btn btn-primary w-100" id="products_btn">
                                {{read_lang_word('related-products')}}
                            </button>
                        </div>
                    @endif
                </div>
            </div>
            <div class="row mt-3" id="text">
                <div class="col-lg-12">
                    <div class="sidebar-widget py-3 px-3 recent_post-widget bg-white widget-padding rounded">
                        <div class="widget-top d-flex mb-4">
                            <h5 class="mb-0 flex-shrink-0">{{read_lang_word('product-description')}}</h5>
                            <span class="spacer align-self-end"></span>
                        </div>
                        <div class="editor-text">
                            {!! read_lang($item,'text') !!}
                        </div>
                    </div>
                </div>
            </div>
            @if(!blank(read_lang($item,'text2')))
                <div class="row mt-3" id="text2">
                    <div class="col-lg-12">
                        <div class="sidebar-widget py-3 px-3 recent_post-widget bg-white widget-padding rounded">
                            <div class="widget-top d-flex mb-4">
                                <h5 class="mb-0 flex-shrink-0">{{read_lang_word('product-info')}}</h5>
                                <span class="spacer align-self-end"></span>
                            </div>
                            <div class="editor-text">
                                {!! read_lang($item,'text2') !!}
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            @if(count($products))
                <!--Product-->
                <section class="blog-section py-5 overflow-hidden" id="products">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-6 col-lg-7">
                                <div class="at-section-title text-center">
                                    <span class="at-subtitle position-relative text-primary lead">{{read_lang_word('related-products')}}</span>
                                    <h2 class="mt-2 h1">{{read_lang_word('related-products2')}}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="blog-card-wrapper mt-2">
                            <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                                <div class="product_swiper2 swiper mySwiper">
                                    <div class="swiper-wrapper">
                                        @foreach($products as $product)
                                            <div class="swiper-slide px-1 py-2">
                                                @include('front.product.includes.card',['item'=>$product])
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="swiper-pagination swiper-pagination1"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            @endif
        </div>
    </section>

    <!--blog list section end-->
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const buttons = document.querySelectorAll('.product_tab_sticky button');
            const container = document.querySelector('.product_tab_sticky .row');

            buttons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetId = this.id.replace('_btn', '');
                    const targetSection = document.getElementById(targetId);
                    if (targetSection) {
                        window.scrollTo({
                            top: targetSection.offsetTop - 130,
                            behavior: 'smooth'
                        });
                    }
                });
            });

            const sections = document.querySelectorAll('[id="text"], [id="text2"], [id="products"]');

            function updateActiveButton() {
                let currentSection = '';
                const scrollPosition = window.scrollY + 150;

                sections.forEach(section => {
                    const sectionTop = section.offsetTop;
                    const sectionHeight = section.offsetHeight;

                    if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
                        currentSection = section.id;
                    }
                });

                buttons.forEach(button => {
                    if (button.id === currentSection + '_btn') {
                        button.classList.add('active-tab');

                        // اینجا: اگر دکمه فعال شد، بیاریمش وسط یا توی دید
                        button.scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });

                    } else {
                        button.classList.remove('active-tab');
                    }
                });
            }

            window.addEventListener('scroll', updateActiveButton);
            updateActiveButton();
        });
    </script>

@endsection
