<!DOCTYPE html>
<html lang="{{app()->getLocale()}}" dir="{{dir_set()}}">
<head>
  <!--required meta tags-->
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

  <title>@if($seo_set) {{$titleSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$titleSeo2}} @endif</title>
  <!--og-->
  <meta property="og:title" content="@if($seo_set) {{$titleSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$titleSeo2}} @endif" />
  <meta property="og:description" content="@if($seo_set) {{$descriptionSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$descriptionSeo2}} @endif"/>
  <meta property="og:site_name" content="@if($seo_set) {{$titleSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$titleSeo2}} @endif" />
  <!--twitter og-->
  <meta name="twitter:title" content="@if($seo_set) {{$titleSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$titleSeo2}} @endif"/>
  <meta name="twitter:description"  content="@if($seo_set) {{$descriptionSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$descriptionSeo2}} @endif"/>
  <!--facebook og-->
  <meta name="description" content="@if($seo_set) {{$descriptionSeo}} @elseif(isset($title) && !blank($title)) {{$title}} @else {{$descriptionSeo2}} @endif"/>

  <meta name="robots" content="{{$robots}}"/>
  <link rel="canonical" href="{{$canonical}}" />

  @if(trim($__env->yieldContent('og_img')))
    @yield('og_img')
  @else
    <meta name="twitter:image" content="{{$fav_icon}}"/>
    <meta property="og:image" content="{{$fav_icon}}"/>
  @endif
  <meta name="author" content="https://adib.com.tr/"/>
  <link rel="alternate" hreflang="{{app()->getLocale()}}" href="{{asset('/')}}" />

  @if(!blank($schemaSeo))
    {!! $schemaSeo !!}
  @endif

  <link rel="icon" href="{{$fav_icon}}" sizes="16x16"/>

  <meta name="base_url" content="{{url('')}}">

  {{-- <!--build:css-->
  <link rel="stylesheet" href="{{url('assets/front/css/main.css?v=1.1.51')}}"/>
  <!--custom css-->
  <link rel="stylesheet" href="{{url('assets/front/css/custom.css?v=1.1.47')}}"/> --}}

  <!-- Dark mode -->
    <script>
      const storedTheme = localStorage.getItem("theme");

      const getPreferredTheme = () => {
        if (storedTheme) {
          return storedTheme;
        }
        return window.matchMedia("(prefers-color-scheme: dark)").matches
          ? "dark"
          : "light";
      };

      const setTheme = function (theme) {
        if (
          theme === "auto" &&
          window.matchMedia("(prefers-color-scheme: dark)").matches
        ) {
          document.documentElement.setAttribute("data-bs-theme", "dark");
        } else {
          document.documentElement.setAttribute("data-bs-theme", theme);
        }
      };

      setTheme(getPreferredTheme());

      window.addEventListener("DOMContentLoaded", () => {
        var el = document.querySelector(".theme-icon-active");
        if (el != "undefined" && el != null) {
          const showActiveTheme = (theme) => {
            const activeThemeIcon = document.querySelector(
              ".theme-icon-active use"
            );
            const btnToActive = document.querySelector(
              `[data-bs-theme-value="${theme}"]`
            );
            const svgOfActiveBtn = btnToActive
              .querySelector(".mode-switch use")
              .getAttribute("href");

            document
              .querySelectorAll("[data-bs-theme-value]")
              .forEach((element) => {
                element.classList.remove("active");
              });

            btnToActive.classList.add("active");
            activeThemeIcon.setAttribute("href", svgOfActiveBtn);
          };

          window
            .matchMedia("(prefers-color-scheme: dark)")
            .addEventListener("change", () => {
              if (storedTheme !== "light" || storedTheme !== "dark") {
                setTheme(getPreferredTheme());
              }
            });

          showActiveTheme(getPreferredTheme());

          document
            .querySelectorAll("[data-bs-theme-value]")
            .forEach((toggle) => {
              toggle.addEventListener("click", () => {
                const theme = toggle.getAttribute("data-bs-theme-value");
                localStorage.setItem("theme", theme);
                setTheme(theme);
                showActiveTheme(theme);
              });
            });
        }
      });
    </script>

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{asset('assets/front/images/logo.png')}}" />

    <!-- Plugins CSS -->
    <link
      rel="stylesheet"
      type="text/css"
      href="{{asset('assets/front/vendor/font-awesome/css/all.min.css')}}"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="{{asset('assets/front/vendor/bootstrap-icons/bootstrap-icons.css')}}"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="{{asset('assets/front/vendor/tiny-slider/tiny-slider.css')}}"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="{{asset('assets/front/vendor/glightbox/css/glightbox.css')}}"
    />

    

<link rel="stylesheet" type="text/css" href="{{asset('assets/front/css/style-rtl.css')}}" />

  @if(dir_set()=='rtl')
    {{-- <link rel="stylesheet" href="{{url('assets/front/css/rtl.css?v=1.1.5')}}"/> --}}
    <!-- Theme CSS -->
    
  @endif
  {{-- @if(font_farsi()=='yes')
    <style>
        h1, h2, h3, h4, h5, h6, p, strong, span, input, select, textarea, optgroup, button, li, a, small, label, td, th, div {
            font-family: iranyekan, sans-serif !important;
        }

        p, strong, span, input, select, textarea, optgroup, button, li, a, label, td, th, div {
            font-size: 14px;
        }
    </style>
  @endif --}}
 
@yield ('styles')
</head>
<body>
<!--main content wrapper start-->
<div class="main-wrapper">

  
  {{-- <x-header type="primary" /> --}}

   {{-- @include('front.layouts.includes_front.mobile_menu') --}}

  {{-- @include('front.layouts.includes_front.breadcrumb') --}}

  @yield ('body')
  <x-footer/>

  {{--@include('front.layouts.includes_front.footer') --}}

</div>

<!--scrolltop button-->
{{-- <button class="theme-scrolltop-btn d-none-print"><i class="fa-regular fa-hand-pointer"></i></button> --}}
<!--scrolltop button end-->

<!--build:js-->
{{-- <script src="{{asset('assets/front/js/vendors/jquery.min.js')}}"></script>
<script src="{{asset('assets/front/js/vendors/popper.min.js')}}"></script>
<script src="{{asset('assets/front/js/vendors/bootstrap.min.js')}}"></script>
<script src="{{asset('assets/front/js/vendors/swiper.min.js')}}"></script>
<script src="{{asset('assets/front/js/app.js?v=1.1.9')}}"></script> --}}
<!--endbuild-->
<!-- sweetalert2 js-->



<div class="back-top">
    <i
    class="bi bi-arrow-up-short position-absolute top-50 start-50 translate-middle"
    ></i>
</div>

<script src="{{asset('assets/front/js/jquery.js')}}"></script>

<!-- Bootstrap JS -->
<script src="{{asset('assets/front/vendor/bootstrap/dist/js/bootstrap.bundle.min.js')}}"></script>

<!-- Vendors -->
<script src="{{asset('assets/front/vendor/tiny-slider/tiny-slider-rtl.js')}}"></script>
<script src="{{asset('assets/front/vendor/glightbox/js/glightbox.js')}}"></script>

<!-- Template Functions -->
<script src="{{asset('assets/front/js/functions.js')}}"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
  @if(session()->has('err_message'))
  $(document).ready(function () {
      Swal.fire({
          title: "{{read_lang_word('unsuccessful')}}",
          text: "{{ session('err_message') }}",
          icon: "warning",
          timer: 6000,
          timerProgressBar: true,
      })
  });
  @endif
  @if(session()->has('flash_message'))
  $(document).ready(function () {
      Swal.fire({
          title: "{{read_lang_word('successful')}}",
          text: "{{ session('flash_message') }}",
          icon: "success",
          timer: 6000,
          timerProgressBar: true,
      })
  })
  ;@endif
  @if (count($errors) > 0)
  $(document).ready(function () {
      Swal.fire({
          title: "{{read_lang_word('unsuccessful')}}",
          icon: "warning",
          html:
                  @foreach ($errors->all() as $key => $error)
                      '<p class="text-right mt-2 ml-5" dir="rtl"> {{$key+1}} : ' +
              '{{ $error }}' +
              '</p>' +
                  @endforeach
                      '<p class="text-right mt-2 ml-5" dir="rtl">' +
              '</p>',
          timer: @if(count($errors)>3)parseInt('{{count($errors)}}') * 1500 @else 6000 @endif,
          timerProgressBar: true,
      })
  });
  @endif
</script>
@yield ('scripts')
{{-- @if($contact_info->whatsapp2)
  <div class="wat_sapp wat_sapp1 d-none-print">
    <a target="_blank" rel="nofollow noopener noreferrer" href="{{$contact_info->whatsapp2}}">
      <img class="social_img" src="{{asset('assets/front/img/whatss.png')}}" alt="...">
    </a>
  </div>
@endif --}}

</body>
</html>
