@extends('front.layouts.front')
@if(!blank($item->photo && is_file($item->photo->path)))
    @section('title_seo')
        <meta name="twitter:image" content="{{url($item->photo->path)}}"/>
        <meta property="og:image" content="{{url($item->photo->path)}}"/>
    @endsection
@endif
@section('styles')
    <link rel="stylesheet" href="{{url('assets/front/css/fancybox.css')}}"/>
@endsection
@section('body')
    <!--blog list section start-->
    <section class="blog-list-section ptb-60">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 mb-4 order-1">
                    <div class="card p-2 text-center">
                        {!! read_lang($item,'top_text') !!}
                    </div>
                </div>
                <div class="col-lg-8 mb-4 order-2">
                    <div class="editor-text card p-4">
                        {!! read_lang($item,'text1') !!}
                    </div>
                </div>
                <div class="col-lg-4 mb-4 order-md-3 order-4">
                    @if($item->chemistry)
                        <img src="{{url($item->chemistry->path)}}" class="w-100"
                             alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}">
                    @endif
                </div>
                <div class="col-lg-4 col-md-5 order-md-4 order-5">
                    <div class="card">
                        <table class="table table-striped w-100 mb-0">
                            <tbody>
                            @foreach($item->attrs_active as $attr)
                                <tr>
                                    <td>{{read_lang($attr,'title')}}</td>
                                    <td>{{read_lang($attr,'value')}}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-lg-8 col-md-7 mb-md-0 mb-4 order-md-5 order-3">
                    <div class="product_view_slider d-flex">
                        <div class="product_thumb_slider_2 px-1 swiper">
                            <div class="swiper-wrapper">
                                @if(count($item->gallery_mobile) && isMobile())
                                    @foreach($item->gallery_mobile as $gallery)
                                        <div class="swiper-slide pb-2">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @else
                                    @foreach($item->gallery as $gallery)
                                        <div class="swiper-slide pb-2">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div class="product_feature_img_slider_2 swiper">
                            <div class="swiper-wrapper">
                                @if(count($item->gallery_mobile) && isMobile())
                                    @foreach($item->gallery_mobile as $gallery)
                                        <div class="swiper-slide" data-fancybox="gallery"
                                             href="{{url($gallery->path)}}">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @else
                                    @foreach($item->gallery as $gallery)
                                        <div class="swiper-slide" data-fancybox="gallery"
                                             href="{{url($gallery->path)}}">
                                            <img src="{{url($gallery->path)}}"
                                                 alt="{{$gallery->alt ?? read_lang($item,'title')}}" class="w-h100">
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="flash-controls flash1-button-prev flash-button-prev"><i
                                        class="fa-solid fa-angle-left"></i>
                            </div>
                            <div class="flash-controls flash1-button-next flash-button-next"><i
                                        class="fa-solid fa-angle-right"></i>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="row mt-4">
                <div class="col-lg-9">
                    <div class="editor-text card p-4">
                        {!! read_lang($item,'text2') !!}
                    </div>

                    @if(count($similar_items))
                        <!--Product-->
                        <section class="blog-section py-5 overflow-hidden">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-xl-6 col-lg-7">
                                        <div class="at-section-title text-center">
                                            <span class="at-subtitle position-relative text-primary lead">{{read_lang_word('encyclopedias')}}</span>
                                            <h2 class="mt-2 h1">{{read_lang_word('encyclopedias-other')}}</h2>
                                        </div>
                                    </div>
                                </div>
                                <div class="blog-card-wrapper mt-2">
                                    <div class="h4-categories-slider-wrapper overflow-hidden px-0">
                                        <div class="product_swiper1 swiper mySwiper">
                                            <div class="swiper-wrapper">
                                                @foreach($similar_items as $similar_item)
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                    <div class="swiper-slide px-1 py-2">
                                                        @include('front.encyclopedia.includes.card',['item'=>$similar_item])
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div class="swiper-pagination swiper-pagination1"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    @endif
                </div>
                <div class="col-lg-3">
                    <div class="blog-sidebar p-sticky_to_992 mt-60 mt-xl-0">
                        <div class="sidebar-widget py-4 px-2 recent_post-widget bg-white widget-padding rounded">
                            <div class="widget-top d-flex mb-4">
                                <h5 class="mb-0 flex-shrink-0">{{read_lang_word('related-products')}}</h5>
                                <span class="spacer align-self-end"></span>
                            </div>
                            <ul class="recent_posts_list mt-30">
                                @foreach($products as $product)
                                    <li class="d-flex align-items-center pointer"
                                        onclick="return window.location.href='{{route('front.product.show',$product->slug)}}'">
                                        <div class="thumb-wrapper">
                                            <img src="{{$product->photo && is_file($product->photo->path)?url($product->photo->path):url('assets/front/img/blog/recent-post-1.jpg')}}"
                                                 alt="{{photo_alt($product,'photo',read_lang($product,'title'))}}"
                                                 class="img-fluid">
                                        </div>
                                        <div class="rp_content w-100">
                                            <span class="mb-1">{{read_lang($product,'title')}}</span>
                                            <div class="text-truncate-3 text-9 mt-2 text-justify">
                                                <small>{!! strip_tags(read_lang($product,'text')) !!}</small>
                                            </div>
                                            <a href="{{route('front.product.show',$product->slug)}}"
                                               class="w-100 mt-3"></a>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--blog list section end-->
@endsection
@section('scripts')
    <script src="{{url('assets/front/js/fancybox.js')}}"></script>
@endsection
