@extends('front.layouts.front')
@section('styles')
  <style>
    iframe
    {
        width: 100%!important;
        height: 400px;
        /* box-shadow: 0 0 2px 0 #66666690;
        border-radius: 5px;
        overflow: hidden;
        padding: 10px; */
        /* -webkit-filter: grayscale(100%);
        filter: grayscale(100%);
        -webkit-transition: all 0.6s ease;
        transition: all 0.6s ease; */
    }
  </style>
@endsection
@section('body')
<x-header type="secondary"/>

<main>
	
<!-- =======================
Page Banner START -->
<section class="pt-5 pb-0" style="background-image:url(assets/front/images/element/map.svg); background-position: center left; background-size: cover;">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-xl-6 text-center mx-auto">
				<!-- Title -->
				<h6 class="text-primary">{{read_lang_word('title-contact')}}</h6>
				<h1 class="mb-4 fs-4">{{read_lang_word('we-are-here-to-help')}}</h1>
			</div>
		</div>
		
		<!-- Contact info box -->
		<div class="row g-4 g-md-5 mt-0 mt-lg-3">
			<!-- Box item -->
            @foreach ($items as $key => $item)
               <div class="col-lg-4 mt-lg-0">
				<div class="card card-body @if($key==0) bg-primary @endif shadow py-5 text-center h-100">
					<!-- Title -->
                    <h5 class="@if($key==0) text-white @endif mb-3 fw-normal">{{read_lang($item, 'title')}}</h5>

					<ul class="list-inline mb-0">
						<!-- Address -->
						<li class="list-item mb-3 @if($key!=0) h6 fw-light @endif">
                            <a href="#" class="@if($key==0) text-white @endif"> <i class="fas fa-fw fa-map-marker-alt me-2 mt-1"></i>{{read_lang($item, 'address')}} </a>
						</li>

						<!-- Phone number -->
                         @foreach (explode(',' , $item->phone) as $phone)
						<li class="list-item  @if($key!=0) mb-2 h6 fw-light @endif">
                            <a rel="nofollow noopener noreferrer" href="tel:{{ str_replace([' ', '-'], '', $phone) }}" class="@if($key==0) text-white @endif"><i class="fas fa-fw fa-phone-alt me-2"></i>{{$phone}}</a>
						</li>
                        @endforeach

						<!-- Email id -->
                        @foreach (explode(',' , $item->email) as $email)
						<li class="list-item  @if($key!=0) mb-2 h6 fw-light  @endif ">
                            <a rel="nofollow noopener noreferrer" href="mailto:{{ $email }}" class="@if($key==0) text-white @endif"><i class="far fa-fw fa-envelope me-2"></i>{{$email}}</a>
						</li>
                        @endforeach

					</ul>
				</div>
			</div> 
            @endforeach
		</div>
	</div>
</section>
<!-- =======================
Page Banner END -->

<!-- =======================
Image and contact form START -->
<section >
	<div class="container">
		<div class="row g-4 g-lg-0 align-items-center">

			<div class="col-md-6 align-items-center text-center">
				<!-- Image -->
				<img src="{{asset('assets/front/images/element/contact.svg')}}" class="h-400px" alt="">

				<!-- Social media button -->
				<div class="d-sm-flex align-items-center justify-content-center mt-2 mt-sm-4">
					<h5 class="mb-0">{{read_lang_word('social-footer')}}</h5> 
					<ul class="list-inline mb-0 ms-sm-2">

                        @if (!empty($items->first()->facebook))
                        <li class="list-inline-item">
                            <a rel="nofollow noopener noreferrer" href="{{$items->first()->facebook}}" target="_blank" class="fs-5 me-1 text-facebook">
                            <i class="fab fa-fw fa-facebook-square"></i>
                            </a>
                        </li>
                        @endif

                        @if (!empty($items->first()->instagram))
                        <li class="list-inline-item">
                            <a rel="nofollow noopener noreferrer" href="{{$items->first()->instagram}}" target="_blank" class="fs-5 me-1 text-instagram">
                            <i class="fab fa-fw fa-instagram"></i>
                            </a>
                        </li>
                        @endif

                        @if (!empty($items->first()->twitter))
                        <li class="list-inline-item">
                            <a rel="nofollow noopener noreferrer" href="{{$items->first()->twitter}}" target="_blank" class="fs-5 me-1 text-twitter">
                            <i class="fab fa-fw fa-twitter"></i>
                            </a>
                        </li>
                        @endif

                        @if (!empty($items->first()->linkedin))
                        <li class="list-inline-item">
                            <a rel="nofollow noopener noreferrer" href="{{$items->first()->linkedin}}" target="_blank" class="fs-5 me-1 text-linkedin">
                            <i class="fab fa-fw fa-linkedin-in"></i>
                            </a>
                        </li>
                        @endif

						{{-- <li class="list-inline-item"> <a class="fs-5 me-1 text-facebook" href="#"><i class="fab fa-fw fa-facebook-square"></i></a> </li>
						<li class="list-inline-item"> <a class="fs-5 me-1 text-instagram" href="#"><i class="fab fa-fw fa-instagram"></i></a> </li>
						<li class="list-inline-item"> <a class="fs-5 me-1 text-twitter" href="#"><i class="fab fa-fw fa-twitter"></i></a> </li>
						<li class="list-inline-item"> <a class="fs-5 me-1 text-linkedin" href="#"><i class="fab fa-fw fa-linkedin-in"></i></a> </li>
						<li class="list-inline-item"> <a class="fs-5 me-1 text-dribbble" href="#"><i class="fas fa-fw fa-basketball-ball"></i></a> </li>
						<li class="list-inline-item"> <a class="fs-5 me-1 text-pinterest" href="#"><i class="fab fa-fw fa-pinterest"></i></a> </li> --}}
					</ul>
				</div>
			</div>

			<!-- Contact form START -->
			<div class="col-md-6">
				<!-- Title -->
				<h2 class="mt-4 mt-md-0 fs-4">{{read_lang_word('stay-in-touch-with-us')}}</h2>
                <p>{{read_lang_word('to-obtain-an-amarsara-representative')}} {{read_lang_word('our-experts-will-contact-you-as-soon-as-possible')}}</p>
                

				<form action="{{route('front.contact.us.post')}}" method="POST" id="form_req">
					@csrf
                    <!-- Name -->
					<div class="mb-4 bg-light-input">
						<label for="yourName" class="form-label">{{read_lang_word('name-family')}} *</label>
						<input type="text" name="name" class="form-control form-control-lg" id="yourName" required>
					</div>
					<!-- Email -->
					<div class="mb-4 bg-light-input">
						<label for="emailInput" class="form-label">{{read_lang_word('email')}} *</label>
						<input type="email" name="email" class="form-control form-control-lg" id="emailInput" required>
					</div>
					<!-- Message -->
					<div class="mb-4 bg-light-input">
						<label for="textareaBox" class="form-label">{{read_lang_word('msg-text')}} *</label>
						<textarea name="message" class="form-control" id="textareaBox" rows="4" required></textarea>
					</div>
					<!-- Button -->
					<div class="d-grid">
						<button class="btn btn-lg btn-primary mb-0" type="submit">{{read_lang_word('submit')}}</button>
					</div>	
				</form>
			</div>
			<!-- Contact form END -->
		</div>
	</div>
</section>
<!-- =======================
Image and contact form END -->

<!-- =======================
Map START -->
@if (!empty($items->first()->address_iframe))
<section class="pt-0">
	<div class="container">
		<div class="row">
			<div class="col-12">
                {!!$items->first()->address_iframe!!}
			</div>
		</div>
	</div>
</section>
@endif
<!-- =======================
Map END -->

</main>
@endsection
@section('scripts')
  @include('front.includes.req')
@endsection
