@extends('front.layouts.front')
@if(!blank($item->photo && is_file($item->photo->path)))
@section('title_seo')
  <meta name="twitter:image" content="{{url($item->photo->path)}}"/>
  <meta property="og:image" content="{{url($item->photo->path)}}"/>
@endsection
@endif
@section('styles') @endsection
@section('body')
<x-header type="scondary"/>

<main>
	
<!-- =======================
Main Content START -->
<section class="pb-0 pt-4 pb-md-5">
	<div class="container">
		<div class="row">
			<div class="col-12">

				<!-- Title and Info START -->
				<div class="row">
					<!-- Avatar and Share -->
					<div class="col-lg-3 align-items-center mt-4 mt-lg-5 order-2 order-lg-1">
						<div class="text-lg-center">
							<!-- Author info -->
							<div class="position-relative">
								<!-- Avatar -->
								<div class="avatar avatar-xxl">
									<img class="avatar-img rounded-circle" src="{{ $item->user->photo ? url($item->user->photo->path) : '' }}" alt="avatar">
								</div>
								<a href="#" class="h5 stretched-link mt-2 mb-0 d-block">{{read_lang($item, 'author')}}</a>
								<p class="mb-2">{{read_lang_word('author')}}</p>
							</div>
							<!-- Info -->
							<ul class="list-inline list-unstyled">
								{{-- <li class="list-inline-item d-lg-block my-lg-2">Nov 15, 2021</li> --}}
								<li class="list-inline-item d-lg-block my-lg-2">{{read_lang_word('min-read')}} 5 {{read_lang_word('minute')}}</li>
								<li class="list-inline-item badge text-bg-orange"><i class="far text-white fa-heart me-1"></i>266</li>
								<li class="list-inline-item badge text-bg-info"><i class="far fa-eye me-1"></i>{{$item->seen}}</li>
							</ul>
						</div>
					</div>

					<!-- Content -->
					<div class="col-lg-9 order-1">
						<!-- Pre title -->
						@if(app()->getLocale() == 'fa')
                            <span  dir="rtl">{{my_jdate($item->created_at,'d F Y')}}</span>
                        @else
                            <span >{{Carbon\Carbon::parse($item->created_at)->toFormattedDateString()}}</span>
                        @endif
                        <span class="mx-2">|</span><div class="badge text-bg-success">{{ read_lang($item->category, 'title') }}</div>
						<!-- Title -->
						<h1 class="mt-2 mb-0 display-5">{{ read_lang($item, 'title') }}</h1>
						<!-- Info -->
						{{-- <p class="mt-2">For who thoroughly her boy estimating conviction. Removed demands expense account in outward tedious do. Particular way thoroughly unaffected projection favorable Mrs can be projecting own. Thirty it matter enable become admire in giving. See resolved goodness felicity shy civility domestic had but. Drawings offended yet answered Jennings perceive laughing six did far.</p>
						<p class="mb-0 mb-lg-3">Perceived end knowledge certainly day sweetness why cordially.  On forth doubt miles of child. Exercise joy man children rejoiced. Yet uncommonly his ten who diminution astonished. Demesne new manners savings staying had. Under folly balls, death own point now men. Match way these she avoids seeing death. She who drift their fat off. Ask a quick six seven offer see among. Handsome met debating sir dwelling age material. As style lived he worse dried. Offered related so visitors we private removed.</p> --}}
					</div>
				</div>
				<!-- Title and Info END -->

				<!-- Video START -->
				<div class="row mt-4">
					<div class="col-xl-10 mx-auto">
                        <img class="w-full rounded-3" src="{{ $item->photo ? url($item->photo->path) : '' }}" alt="">
					</div>
				</div>
				<!-- Video END -->

				<div class="my-5">
                    {!! read_lang($item, 'text') !!}
                </div>
				

				<!-- Tags and share START -->
				<div class="d-lg-flex justify-content-lg-between mb-4">
					<!-- Social media button -->
                    <x-sharing-social :title="$title"/>
					<!-- Popular tags -->
                    @if(!empty($tags))
                    <div class="align-items-center">
						<h6 class="mb-2 me-4 d-inline-block">{{read_lang_word('tags')}}:</h6>
						<ul class="list-inline mb-0 social-media-btn">
                            @foreach ($tags as $tag)
                                <li class="list-inline-item"> <a class="btn btn-outline-light btn-sm mb-lg-0" href="#">{{read_lang($tag, 'title')}}</a> </li>
                            @endforeach
						</ul>
					</div>
                    @endif
					
				</div>
				<!-- Tags and share END -->

				<hr> <!-- Divider -->

				<!-- Comment review and form START -->
				<div class="row mt-4">
					<!-- Comment START -->
					<div class="col-md-7">
						<h3>{{count($comments)}} {{read_lang_word('opinion')}}</h3>
						<!-- Comment level 1-->
                        @foreach ($comments as $comment)
                        <div class=" d-flex mt-5">
                             <div  class=" rounded-circle me-3">
                                {!! \App\Helpers\GravatarHelper::getImage(
                                    $comment->email,
                                    $comment->name,
                                    50
                                ) !!}
                             </div>
							{{-- <img class="avatar avatar-md rounded-circle me-3" src="assets/images/avatar/01.jpg" alt="avatar"> --}}
							<div>
								<div class="mb-2">
									<h5 class="m-0">{{$comment->name}}</h5>
                                    @if(app()->getLocale() == 'fa')
                                        <span class="me-3 small" dir="rtl">{{my_jdate($item->created_at,'d F Y')}}</span>
                                    @else
                                        <span class="me-3 small">{{Carbon\Carbon::parse($item->created_at)->toFormattedDateString()}}</span>
                                    @endif
								</div>
								
								{{-- <a href="#" class="btn btn-sm btn-light mb-0">Reply</a> --}}
							</div>
						</div>

                        {!! $comment->message !!}
                        @endforeach
						
						<!-- Comment children level 2 -->
						{{-- <div class="my-4 d-flex ps-2 ps-md-4">
							<img class="avatar avatar-md rounded-circle me-3" src="assets/images/avatar/02.jpg" alt="avatar">
							<div>
								<div class="mb-2">
									<h5 class="m-0">Louis Ferguson</h5>
									<span class="me-3 small">June 11, 2021 at 6:55 am</span>
								</div>
								<p>Water timed folly right aware if oh truth. Imprudence attachment him for sympathize. Large above be to means. Dashwood does provide stronger is. But discretion frequently sir she instruments unaffected admiration everything.</p>
								<a href="#" class="btn btn-sm btn-light mb-0">Reply</a>
							</div>
						</div> --}}
						
					</div>
					<!-- Comment END -->

					<!-- Form START -->
					<div class="col-md-5">
						<!-- Title -->
						<h3 class="mt-3 mt-sm-0">{{read_lang_word('your-opinion')}}</h3>
						{{-- <small>Your email address will not be published. Required fields are marked *</small> --}}

						<form action="{{route('front.comment.post')}}" method="POST" id="form_req" class="row g-3 mt-2 mb-5">
                            @csrf
                            <input type="hidden" name="commentable_id" value="{{ $item->id }}">
                            <input type="hidden" name="commentable_type" value="{{ get_class($item) }}">
							<!-- Name -->
							<div class="col-lg-6">
								<label class="form-label">{{read_lang_word('name')}} *</label>
								<input type="text" name="name" class="form-control" required>
							</div>
							<!-- Email -->
							<div class="col-lg-6">
								<label class="form-label">{{read_lang_word('email')}} *</label>
								<input type="email" name="email" class="form-control" required>
							</div>
							<!-- Comment -->
							<div class="col-12">
								<label class="form-label">{{read_lang_word('msg-text')}} *</label>
								<textarea name="message" class="form-control" rows="3" required></textarea>
							</div>
							<!-- Button -->
							<div class="col-12">
								<button type="submit" class="btn btn-primary mb-0">{{read_lang_word('submit')}}</button>
							</div>
						</form>
					</div>
					<!-- Form END -->
				</div>
				<!-- Comment review and form END -->
			</div>
		</div> <!-- Row END -->
	</div>
</section>
<!-- =======================
Main Content END -->

<!-- =======================
Related blog START -->
<section class="pt-0">
	<div class="container">
    <!-- Title -->
		<div class="row mb-4">
			<div class="col-12">
			<h2 class="mb-0">جدیدترین مقالات</h2>
			</div>
		</div>
		
		<!-- Slider START -->
		<div class="tiny-slider arrow-round arrow-hover arrow-dark">
			<div class="tiny-slider-inner" data-autoplay="false" data-arrow="true" data-edge="2" data-dots="false" data-items="3" data-items-lg="2" data-items-sm="1">
				
				<!-- Slider item -->
                @foreach ($items_last as $item_l)
                <div class="card bg-transparent">
					<div class="row g-0">
						<!-- Image -->
						<div class="col-md-4">
							<img src="{{ $item_l->photo ? url($item_l->photo->path) : '' }}" class="img-fluid rounded-start" alt="...">
						</div>
						<!-- Card body -->
						<div class="col-md-8">
							<div class="card-body">
								<!-- Title -->
								<h6 class="card-title"><a href="{{route('front.blog.show', $item_l->slug)}}">{{ read_lang($item_l, 'title') }}</a></h6>

                                @if(app()->getLocale() == 'fa')
                                <span class="small" dir="rtl">{{my_jdate($item_l->created_at,'d F Y')}}</span>
                                @else
                                    <span class="small">{{Carbon\Carbon::parse($item_l->created_at)->toFormattedDateString()}}</span>
                                @endif

							</div>
						</div>
					</div>
				</div>
                @endforeach
				

				
			</div>
		</div>
		<!-- Slider END -->
	</div>
</section>
<!-- =======================
Related blog END -->

</main>
@endsection

@section('scripts')
  @include('front.includes.req')
@endsection
