{{-- resources/views/auth/passwords/request.blade.php --}}
@extends('front.layouts.front')
@section('body')
<div class="container" style="max-width:400px;margin-bottom: 20rem;padding-top:10rem" >

    <div class="alert alert-warning d-flex align-items-center" role="alert">  
        روی دامنه اصلی سیستم ارسال ایمیل و پیامک رو پیاده سازی میکنیم 
    </div>

  <h3 class="mb-4">بازیابی رمز عبور</h3>

  <form id="step1">
    @csrf
    <div class="mb-3">
      <label>ایمیل یا موبایل</label>
      <input type="text" name="identity" class="form-control" required>
      <div class="" id="identity-error"></div>
    </div>
    <button type="submit" class="btn btn-primary w-100">ارسال کد</button>
  </form>

 <form id="step2" style="display:none;">
  @csrf
  <input type="hidden" name="identity">
  
  <div class="mb-3">
    <label>کد تایید (۶ رقم)</label>
    <input type="text" name="code" class="form-control" maxlength="6" required>
    <div class="" id="code-error"></div>
    <div class="" id="result-code"></div>
  </div>

  <button type="submit" class="btn btn-success w-100 mb-2">تایید کد</button>
  
  <!-- دکمه ارسال مجدد: دیگر متن ثابت است و فقط عدد زمان داخل span تغییر می‌کند -->
  <button type="button" id="resend" class="btn btn-link" disabled>
    ارسال مجدد کد <span id="timer">60</span>
  </button>
</form>

  <form id="step3" action="{{ route('password.reset') }}" method="POST" style="display:none;">
    @csrf
    <div class="mb-3">
      <label>رمز جدید</label>
      <input type="password" name="password" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>تکرار رمز جدید</label>
      <input type="password" name="password_confirmation" class="form-control" required>
    </div>
    <button type="submit" class="btn btn-primary w-100">تغییر رمز</button>
  </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  const step1 = document.getElementById('step1');
  const step2 = document.getElementById('step2');
  const identityInputStep2 = step2.querySelector('input[name="identity"]');
  const resendBtn = document.getElementById('resend');
  const timerEl  = document.getElementById('timer');
  let countdownId;

  // تابع شروع تایمر: قبل از هر چیز تایمر قبلی رو پاک می‌کنه
  function startTimer() {
    clearInterval(countdownId);
    let time = 60;
    resendBtn.disabled = true;
    timerEl.textContent = time;

    countdownId = setInterval(() => {
      time--;
      timerEl.textContent = time;
      if (time <= 0) {
        clearInterval(countdownId);
        resendBtn.disabled = false;
        timerEl.textContent = '';
      }
    }, 1000);
  }

  // مرحله اول: ارسال اولیه‌ی کد
  step1.addEventListener('submit', function(e){
    e.preventDefault();
    const formData = new FormData(step1);

    fetch("{{ route('password.sendCode') }}", {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': formData.get('_token'),
        'Accept': 'application/json',
        // Content-Type را ننویسید تا Fetch خودش بگذارد
      },
      body: formData
    })
    .then(res => res.json())
    .then(json => {
      if (json.status === 'code_sent') {
        document.getElementById('result-code').innerText=json.code
        step1.style.display = 'none';
        step2.style.display = 'block';
        identityInputStep2.value = formData.get('identity');
        startTimer();
      } else {
        document.getElementById('identity-error').innerText = json.message || 'خطا در ارسال کد';
      }
    })
    .catch(() => {
      document.getElementById('identity-error').innerText = 'خطای شبکه. دوباره تلاش کنید.';
    });
  });

  // مرحله دوم: تأیید کد
  step2.addEventListener('submit', function(e){
    e.preventDefault();
    const formData = new FormData(step2);

    fetch("{{ route('password.verifyCode') }}", {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': formData.get('_token'),
        'Accept': 'application/json',
      },
      body: formData
    })
    .then(res => res.json())
    .then(json => {
      if (json.status === 'verified') {
        clearInterval(countdownId);
        step2.style.display = 'none';
        document.getElementById('step3').style.display = 'block';
      } else {
        document.getElementById('code-error').innerText = json.message || 'کد نامعتبر';
      }
    })
    .catch(() => {
      document.getElementById('code-error').innerText = 'خطای شبکه. دوباره تلاش کنید.';
    });
  });

  // ارسال مجدد کد
  resendBtn.addEventListener('click', function(){
    if (resendBtn.disabled) return;

    const identity = identityInputStep2.value;
    const token = document.querySelector('#step2 input[name="_token"]').value;

    fetch("{{ route('password.sendCode') }}", {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': token,
        'Accept': 'application/json',
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ identity })
    })
    .then(res => res.json())
    .then(json => {
      if (json.status === 'code_sent') {
        startTimer();
        document.getElementById('result-code').innerText=json.code
      } else {
        // می‌توانید پیام خطا نمایش دهید
        alert(json.message || 'خطا در ارسال مجدد کد');
      }
    })
    .catch(() => {
      alert('خطای شبکه. دوباره تلاش کنید.');
    });
  });

});
</script>
@endsection
