<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>ورود</title>

    <link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;700&amp;family=Roboto:wght@400;500;700&amp;display=swap">

	<!-- Plugins CSS -->
	<link rel="stylesheet" type="text/css" href="{{asset('assets/front/vendor/font-awesome/css/all.min.css')}}">
	<link rel="stylesheet" type="text/css" href="{{asset('assets/front/vendor/bootstrap-icons/bootstrap-icons.css')}}">

	<!-- Theme CSS -->
	{{-- <link rel="stylesheet" type="text/css" href="{{asset('assets/front/css/style.css')}}"> --}}
    <link rel="stylesheet" type="text/css" href="{{asset('assets/front/css/style-rtl.css')}}" />
</head>
<body>
    <main>
	<section class="p-0 d-flex align-items-center position-relative overflow-hidden">
	
		<div class="container-fluid">
			<div style="direction: rtl" class="row">
                <!-- Right -->
				<div class="col-12 col-lg-6 m-auto bg-white rounded">
					<div class="row my-5">
						<div class="col-sm-10 col-xl-8 m-auto">
							<!-- Title -->
							{{-- <img src="{{asset('assets/front/images/element/03.svg')}}" class="h-40px mb-2" alt=""> --}}
							<h2 class="text-center">ورود کاربر</h2>
						
							<!-- Form START -->
							<form method="POST" action="{{ route('login') }}" id="form_req">
                                @csrf
                               
								<!-- Email Or Phone -->
								<div class="mb-4">
									<label for="exampleInputEmail1" class="form-label">{{read_lang_word('email')}} | {{read_lang_word('phone')}} *</label>
									<input name="username" value="{{ old('username') }}" type="text" class="form-control border-0 bg-light rounded-end ps-1" placeholder="" id="exampleInputEmail1">
									@error('username')<div class="">{{ $message }}</div>@enderror
								</div>
								<!-- Password -->
								<div class="mb-4">
									<label for="inputPassword5" class="form-label">{{read_lang_word('password')}} *</label>
									<input name="password" type="password" class="form-control border-0 bg-light rounded-end ps-1" placeholder="*********" >
									@error('password')<div class="">{{ $message }}</div>@enderror
								</div>
                               
								<!-- Button -->
								<div class="align-items-center mt-0">
									<button type="submit" class="btn btn-primary mb-0  w-100" type="button">{{read_lang_word('login')}}</button>
								</div>
							</form>

                            <div class="mt-4 text-center">
								<span>حساب ندارید؟<a href="{{route('register')}}"> ساخت حساب </a></span>
							</div>
							
						</div>
					</div>
				</div>
				<!-- left -->
				<div class="col-12 col-lg-6 d-md-flex align-items-center justify-content-center  bg-opacity-10 vh-lg-100">
					<div class="p-3 p-lg-5">
                        <div class="text-center">
							<a href="{{route('front.index')}}" class="mb-0 h6 fw-bold">صفحه اصلی</a>
						</div>
						<img src="{{asset('assets/front/images/element/02.svg')}}" class="mt-5" alt="">
					</div>
				</div>

				
			</div>
		</div>
	</section>
</main>

{{-- @section('scripts') --}}
  {{-- @include('front.includes.req') --}}
{{-- @endsection --}}
</body>
</html>






{{-- @extends('admin.layouts.app')
@section('styles')
    <style>
        .app-content
        {
            margin-right: unset!important;
            margin-top: 20px!important;
        }
        footer.footer
        {
            padding: unset;
        }
    </style>
@endsection
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="col-lg-3 col-md-4 col-sm-6 mx-auto mb-4 login_logo">
                <a href="{{asset('/')}}" target="_blank">
                    <img src="{{asset($logo && $logo->logo && is_file($logo->logo->path)?$logo->logo->path:'')}}" class="w-100" alt="Adib">
                </a>
            </div>
        </div>
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">ورود به پنل</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">نام کاربری</label>

                            <div class="col-md-6">
                                <input id="username" type="text" class="form-control d-ltr text-left @error('username') is-invalid @enderror" name="username" value="{{ old('username') }}" required autocomplete="username" autofocus>

                                @error('username')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-md-4 col-form-label text-md-right">رمز عبور</label>

                            <div class="col-md-6">
                                <input id="password" type="password" class="form-control d-ltr text-left @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>


                        <div class="form-group row mb-0">
                            <div class="col-md-12 text-left">
                                <button type="submit" class="btn btn-primary">
                                    ورود
                                </button>


                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection --}}
