@extends('admin.layouts.app',['tbl'=>true])



@section('content')

    <div class="row mt-5">

        <div class="col-xl-12 col-md-12 col-lg-12">

            <div class="card">

                <div class="card-header  border-0">

                    <h4 class="w-100">

                        {{$title}}

                        @can('product_create')

                            <a href="{{route('admin.product.create')}}" class="btn btn-primary float-left">افزودن</a>

                        @endcan

                    </h4>

                </div>



                <div class="card-body">

                    <div class="table-responsive">

                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">

                            <thead>

                            <tr>

                                <th class="border-bottom-0">ردیف</th>

                                <th class="border-bottom-0">شماره درخواست</th>

                                <th class="border-bottom-0">مبلغ</th>

                                <th class="border-bottom-0">کاربر</th>

                                <th class="border-bottom-0">وضعیت فعلی</th>

                                @canany(['product_edit','product_delete','product_attr'])

                                    <th class="border-bottom-0">عملیات</th>

                                @endcan

                            </tr>

                            </thead>

                            <tbody>

                            @foreach($requests as $key=>$req)

                                <tr>

                                    <td>{{$key+1}}</td>

                                    <td>

                                        {{$req->request_number}}

                                    </td>

                                    <td>

                                        {{number_format($req->amount)}}

                                    </td>

                                    <td>

                                    {{$req->user->name}}

                                    </td>

                                    <td class="{{$req->getStatus()['color']}}">

                                    {{$req->getStatus()['msg']}}

                                    </td>

                                    @canany(['product_edit','product_delete','product_attr'])

                                        <td>

                                            <div class="d-flex">


                                                @can('product_edit')

                                                    <a href="{{route('admin.withdraw-requests.edit',$req->id)}}"

                                                       class="action-btns1">

                                                        <i class="feather feather-edit-2  text-success"

                                                           data-toggle="tooltip" data-placement="top"

                                                           title="ویرایش"></i>

                                                    </a>

                                                @endcan

                                                @can('product_delete')

                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product.destroy', $req->id] ]) !!}

                                                    <button class="action-btns1" data-toggle="tooltip"

                                                            data-placement="top" title="حذف"

                                                            onclick="return confirm('برای حذف مطمئن هستید؟')">

                                                        <i class="feather feather-trash-2 text-danger"></i>

                                                    </button>

                                                    {!! Form::close() !!}

                                                @endcan

                                            </div>

                                        </td>

                                    @endcan

                                </tr>

                            @endforeach

                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>



@endsection

