@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.user.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('name', 'نام * ')}}
                                {{Form::text('name',null, array('class' => 'form-control','required'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('role_name', 'دسترسی * ')}}
                                {{ Form::select('role_name', array_pluck($roles,'title','name',['','انتخاب کنید']), null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                        </div>
                        <div class="col-md-12">
                            {{Form::label('info', 'اطلاعات کاربر ')}}
                            <div class="form-group form-group-post">
                                {{Form::textarea('info', null, array('class' => 'form-control textarea_rtl'))}}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('username', 'نام کاربری * ')}}
                                {{Form::text('username',null, array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                            <p class="text-danger">_<small>بین 4 تا 20 کاراکتر</small></p>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('password', 'رمز عبور * ')}}
                                {{Form::password('password', array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                            <p class="text-danger">_<small>حداقل 6 کاراکتر</small></p>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('password_confirmation', 'تکرار رمز عبور * ')}}
                                {{Form::password('password_confirmation', array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                            <p class="text-danger">_<small>حداقل 6 کاراکتر</small></p>
                            <p class="text-danger">_<small>یکسان با رمز عبور</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', 'تصویر ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp'))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 2Mb می باشد</small></p>
                            <p class="text-danger">_<small>بهترین سایز تصویر عرض 120 پیکسل در ارتفاع 150 پیکسل می
                                    باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@push('in_tag_script')

@endpush
