@extends('admin.layouts.app',['req'=>true,'date_picker'=>true,'file_upload'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.upload.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('title', ' عنوان *')}}
                {{Form::text('title', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <div class="form-group">
                  {{Form::label('file', ' فایل *')}}
                  <div class="input-group mb-5 file-browser">
                    <input type="text" class="form-control browse-file"
                           placeholder="فایل خود را جهت آپلود انتخاب نمایید" readonly>
                    <label class="input-group-append">
												<span class="btn btn-primary">
													انتخاب
                                                    {{Form::file('file', array('class' => 'file-browserinput d-none','accept' => '*.*','required'))}}
												</span>
                    </label>
                  </div>

                </div>
              </div>
              <p class="text-danger">_<small>حداکثر حجم 50Mb می باشد</small></p>
            </div>

            <div class="col-md-12 text-left">
              <hr/>
              {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>


@endsection
