@extends('admin.layouts.app',['tbl'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            <a href="{{route('admin.meta.create')}}" class="btn btn-primary float-left">افزودن</a>
          </h4>
        </div>

        <div class="card-body">
          <div class="col-12">
            <div class="alert alert-info text-center">
              برای کپی کردن لینک رو کلمه "لینک" راست کلیک سپس روی <span dir="ltr"> "copy link address" </span> کلیک کنید
            </div>
          </div>
          <div class="table-responsive">
            <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
              <thead>
              <tr>
                <th class="border-bottom-0">ردیف</th>
                <th class="border-bottom-0">عنوان</th>
                <th class="border-bottom-0">عنوان صفحه</th>
                <th class="border-bottom-0">لینک</th>
{{--                @can('meta_status')--}}
{{--                  <th class="border-bottom-0">وضعیت</th>--}}
{{--                @endcan--}}
                @canany(['meta_edit','meta_delete'])
                  <th class="border-bottom-0">عملیات</th>
                @endcan
              </tr>
              </thead>
              <tbody>
              @foreach($items as $key=>$item)
                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{$item->name_page}}</td>
                  <td>{{$item->title_page}}</td>
                  <td><a href="{{$item->link}}" target="_blank">لینک</a></td>
{{--                  @can('meta_status')--}}
{{--                    <td>--}}
{{--                      @if($item->status=='active')--}}
{{--                        <span class="text-success ml-2">فعال</span>--}}
{{--                        <a href="{{route('admin.meta.status',[$item->id,'status','pending'])}}">--}}
{{--                          <i class="fa fa-close text-danger"></i>--}}
{{--                        </a>--}}
{{--                      @else--}}
{{--                        <span class="text-danger ml-2">غیرفعال</span>--}}
{{--                        <a href="{{route('admin.meta.status',[$item->id,'status','active'])}}">--}}
{{--                          <i class="fa fa-check text-success"></i>--}}
{{--                        </a>--}}
{{--                      @endif--}}
{{--                    </td>--}}
{{--                  @endcan--}}
                  @canany(['meta_edit','meta_delete'])
                    <td>
                      <div class="d-flex">
                        @can('meta_edit')
                          <a href="{{route('admin.meta.edit',$item->id)}}"
                             class="action-btns1">
                            <i class="feather feather-edit-2  text-success"
                               data-toggle="tooltip" data-placement="top"
                               title="ویرایش"></i>
                          </a>
                        @endcan
                        @can('meta_delete')
                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.meta.destroy', $item->id] ]) !!}
                          <button class="action-btns1" data-toggle="tooltip"
                                  data-placement="top" title="حذف"
                                  onclick="return confirm('برای حذف مطمئن هستید؟')">
                            <i class="feather feather-trash-2 text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                      </div>
                    </td>
                  @endcan
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
