@extends('admin.layouts.app',['req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.contact.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, 'عنوان * ')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control','required'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'address':'address_'.$lang->lang, 'آدرس ')}}
                                                    {{Form::text($lang->status=='default'?'address':'address_'.$lang->lang, read_lang($item,'address',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            {{-- <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'address2':'address2_'.$lang->lang, 'آدرس 2')}}
                                                    {{Form::text($lang->status=='default'?'address2':'address2_'.$lang->lang, read_lang($item,'address2',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div> --}}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        {{-- <div class="col-md-12 d-none">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', 'تصویر ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>بهترین سایز تصویر عرض 1100 پیکسل در ارتفاع 280 پیکسل می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید JPG,JPEG,WEBP باشد</small></p>
                        </div> --}}

                       
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('phone', ' شماره تماس *')}}
                                {{Form::text('phone', null, array('class' => 'form-control d-ltr text-left contact_multi','required'))}}
                            </div>
                            <p class="text-danger">_<small>درصورت داشتن چند شماره تماس میتوانید با زدن "Add" به تعداد شماره را وارد کنید</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('mobile', ' شماره موبایل')}}
                                {{Form::text('mobile', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>درصورت داشتن چند شماره موبایل میتوانید با زدن "Add" به تعداد شماره را وارد کنید</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('fax', ' شماره فکس')}}
                                {{Form::text('fax', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>درصورت داشتن چند شماره فکس میتوانید با زدن "Add" به تعداد شماره را وارد کنید</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('email', 'ایمیل *')}}
                                {{Form::text('email', null, array('class' => 'form-control d-ltr text-left contact_multi','required'))}}
                            </div>
                            <p class="text-danger">_<small>درصورت داشتن چند ایمیل میتوانید با زدن "Add" به تعداد ایمیل ها را وارد کنید</small></p>
                        </div>

                        @if ($item->id == 1)
                            <div class="col-md-12">
                            <div class="form-group">
                                {{Form::label('address_iframe', ' آدرس آیفریم *')}}
                                {{Form::text('address_iframe', null, array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                        </div>
                        <div class="col-md-12 d-none">
                            <div class="form-group">
                                {{Form::label('whatsapp', ' شماره واتساپ')}}
                                {{Form::text('whatsapp', null, array('class' => 'form-control d-ltr text-left contact_multi'))}}
                            </div>
                            <p class="text-danger">_<small>درصورت داشتن چند شماره واتساپ میتوانید با زدن "Add" به تعداد شماره را وارد کنید</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('whatsapp2', ' شماره واتساپ(گوشه سایت)')}}
                                {{Form::url('whatsapp2', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>این شماره واتساپ می باشد</small></p>
                            <p class="text-danger">_<small dir="ltr">https://api.whatsapp.com/send?phone=989121113355</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('telegram', 'تلگرام')}}
                                {{Form::url('telegram', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://t.me/TelegramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('instagram', 'اینستاگرام')}}
                                {{Form::url('instagram', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://instagram.com/InstagramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('facebook', 'فیسبوک')}}
                                {{Form::url('facebook', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.facebook.com/FacebookId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('twitter', 'توئیتر')}}
                                {{Form::url('twitter', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://twitter.com/TwitterId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('linkedin', 'لینکدین')}}
                                {{Form::url('linkedin', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.linkedin.com/in/linkedinId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('youtube', 'یوتیوب')}}
                                {{Form::url('youtube', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.youtube.com/youtubeId</small></p>
                        </div>
                        <div class="col-md-6 d-none">
                            <div class="form-group">
                                {{Form::label('aparat', 'آپارات')}}
                                {{Form::url('aparat', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.aparat.com/aparatId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('whatsapp_group', 'گروه واتساپ')}}
                                {{Form::url('whatsapp_group', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://chat.whatsapp.com/GroupId</small></p>
                        </div>
                        @endif
                        
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('ویرایش',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
