@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.product.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div
                                    class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                    id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, 'عنوان ')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'top_text':'top_text_'.$lang->lang, 'توضیحات بالای جدول(حداکثر 1000 کاراکتر)')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'top_text':'top_text_'.$lang->lang, read_lang($item,'top_text',$lang->lang), array('class' => 'form-control','rows'=>3))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, 'توضیحات')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text2':'text2_'.$lang->lang, 'مشخصات محصول')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text2':'text2_'.$lang->lang, read_lang($item,'text2',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, ' عنوان صفحه(سئو)')}}
                                                    {{Form::text($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, read_lang($item,'meta_title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, ' توضیحات(سئو)')}}
                                                    {{Form::text($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, read_lang($item,'meta_description',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id', 'دسته بندی  *')}}
                                {{ Form::select('category_id', array_pluck($cats_id, 'title', 'id',['','انتخاب کنید']), null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('slug', 'اسلاگ  *')}}
                                {{ Form::text('slug', null, array('class' => 'form-control slug_input','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('photo', 'تصویر ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos', ' تصاویر(دکستاپ)')}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="تصاویر خود را جهت آپلود انتخاب نمایید" readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                انتخاب
                                                {{Form::file('photos[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم هر تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                        </div>
                        @if(count($item->gallery))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->gallery as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->path)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.pic.delete',$photo->id)}}"
                                                       onclick="return confirm('برای حذف مطمئن هستید؟')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="حذف">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos_mobile', ' تصاویر(موبایل)')}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file"
                                               placeholder="تصاویر خود را جهت آپلود انتخاب نمایید" readonly>
                                        <label class="input-group-append">
                                            <span class="btn btn-primary">
                                                انتخاب
                                                {{Form::file('photos_mobile[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم هر تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                        </div>
                        @if(count($item->gallery_mobile))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->gallery_mobile as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->path)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.pic.delete',$photo->id)}}"
                                                       onclick="return confirm('برای حذف مطمئن هستید؟')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="حذف">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('ویرایش',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@push('in_tag_script')

@endpush
