@extends('admin.layouts.app',['req'=>true,'editor'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.faq.store', 'method' => 'POST','id'=>'form_req')) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], null, array('class' => 'form-control select2-show-search custom-select','required')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'question':'question_'.$lang->lang, ' سوال')}}
                                                    {{Form::text($lang->status=='default'?'question':'question_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'answer':'answer_'.$lang->lang,'جواب')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'answer':'answer_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                    
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('افزودن',array('class'=>'btn btn-primary news_submit'))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@push('in_tag_script')
    <script src="{{ url('assets/editor/laravel-ckeditor/ckeditor.js') }}"></script>
    <script src="{{ url('assets/editor/laravel-ckeditor/adapters/jquery.js') }}"></script>
    <script type="text/javascript">
        var textareaOptions = {
            filebrowserImageBrowseUrl: '{{ url('filemanager?type=Images') }}',
            filebrowserImageUploadUrl: '{{ url('filemanager/upload?type=Images&_token=') }}',
            filebrowserBrowseUrl: '{{ url('filemanager?type=Files') }}',
            filebrowserUploadUrl: '{{ url('filemanager/upload?type=Files&_token=') }}',
            language: 'fa'
        };
        $('.textarea').ckeditor(textareaOptions);
        $('.news_submit').on('click',function (){
            var r = confirm("برای ارسال فرم مطمئن هستید؟");
            if (r == true) {
                $('#global-loader-form').css('display', 'block');
                $('#form_req').submit()
            } else {
            }
        })
    </script>
@endpush
