<!--aside open-->
<aside class="app-sidebar">
    <div class="app-sidebar__logo">
        <a class="header-brand" href="{{ route('front.index') }}" target="_blank">
            <img src="{{ $logo }}" class="header-brand-img desktop-lgo h-100" alt="Adib">
            <img src="{{ $logo }}" class="header-brand-img dark-logo h-100" alt="Adib">
            <img src="{{ $fav_icon }}" class="header-brand-img mobile-logo h-100" alt="Adib">
            <img src="{{ $fav_icon }}" class="header-brand-img darkmobile-logo h-100" alt="Adib">
        </a>
    </div>
    <div class="app-sidebar3">
        <div class="app-sidebar__user">
            <div class="dropdown user-pro-body text-center">
                <div class="user-pic">
                    <img src="{{ auth()->user()->photo && is_file(auth()->user()->photo->path) ? url(auth()->user()->photo->path) : url('assets/admin/images/admin.jpg') }}"
                        alt="user-img" class="avatar-xxl rounded-circle mb-1 object-fit-cover">
                </div>
                <div class="user-info">
                    <h5 class=" mb-2">{{ auth()->user()->name }}</h5>
                    <span
                        class="text-muted app-sidebar__user-name text-sm">{{ auth()->user()->roles->first()->title }}</span>
                </div>
            </div>
        </div>

        <ul class="side-menu">
            @if (session()->has('admin_id'))
                <li class="slide">
                    <a class="btn btn-danger w-100" href="{{ route('admin.user.back.login') }}">
                        <i class="fa fa-sign-out sidemenu_icon"></i>
                        برگشت به پنل خودم
                    </a>
                </li>
            @endif
            @canany(['permission_cat_list', 'permission_list', 'role_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-key sidemenu_icon"></i>
                        <span class="side-menu__label">مجوزها</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('permission_cat_list')
                            <li><a href="{{ route('admin.permission-cat.index') }}" class="slide-item">جداول</a></li>
                        @endcan
                        @can('permission_list')
                            <li><a href="{{ route('admin.permission.index') }}" class="slide-item">مجوز</a></li>
                        @endcan
                        @can('role_list')
                            <li><a href="{{ route('admin.role.index') }}" class="slide-item">سطح دسترسی</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['user_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-users sidemenu_icon"></i>
                        <span class="side-menu__label">کاربران</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('user_list')
                            <li><a href="{{ route('admin.user.index') }}" class="slide-item"> کاربران</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['gallery_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-image sidemenu_icon"></i>
                        <span class="side-menu__label">گالری</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('gallery_list')
                            <li><a href="{{ route('admin.gallery.index') }}" class="slide-item">تصاویر/ویدئو</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['service_list', 'faq_list', 'certificate_list', 'partner_list', 'banner_list', 'team_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-info sidemenu_icon"></i>
                        <span class="side-menu__label">دیگر اطلاعات</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('service_list')
                            <li><a href="{{ route('admin.service.index') }}" class="slide-item">خدمات</a></li>
                        @endcan
                        @can('faq_list')
                            <li><a href="{{ route('admin.faq.index') }}" class="slide-item">سوالات متداول</a></li>
                        @endcan
                        @can('certificate_list')
                            <li><a href="{{ route('admin.certificate.index') }}" class="slide-item">گواهینامه ها</a></li>
                        @endcan
                        @can('partner_list')
                            <li><a href="{{ route('admin.partner.index') }}" class="slide-item">همکاران ما</a></li>
                        @endcan
                        @can('banner_list')
                            <li><a href="{{ route('admin.banner.index') }}" class="slide-item">بنر</a></li>
                        @endcan
                        @can('team_list')
                            <li><a href="{{ route('admin.team.index') }}" class="slide-item">تیم ما</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['blog_list', 'blog_category_list', 'tag_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="feather feather-edit-2  sidemenu_icon"></i>
                        <span class="side-menu__label">بلاگ</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('blog_list')
                            <li><a href="{{ route('admin.blog.index') }}" class="slide-item">مقالات</a></li>
                        @endcan
                        @can('blog_category_list')
                            <li><a href="{{ route('admin.blog-category.index') }}" class="slide-item">دسته بندی مقالات</a>
                            </li>
                        @endcan
                        @can('tag_list')
                            <li><a href="{{ route('admin.tags.index') }}" class="slide-item">برچسب ها</a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['blog_list', 'blog_category_list', 'tag_list'])
            <li class="slide">
                <a class="side-menu__item" data-toggle="slide" href="#">
                    <i class="feather feather-edit-2  sidemenu_icon"></i>
                    <span class="side-menu__label">مالی</span><i class="angle fa fa-angle-left"></i>
                </a>
                <ul class="slide-menu">
                    @can('blog_list')
                        <li><a href="{{ route('admin.withdraw-requests.index') }}" class="slide-item">مدیریت درخواست های برداشت</a></li>
                    @endcan
                    @can('blog_category_list')
                        <li><a href="{{ route('front.withdraw-request.index') }}" class="slide-item">درخواست های برداشت من</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan
            @canany(['product_category_list', 'product_list', 'encyclopedia_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="feather feather-share-2 sidemenu_icon"></i>
                        <span class="side-menu__label">مدیریت کتابخانه</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('product_encyclopedia_list')
                            <li><a href="{{ route('admin.library-categories.index') }}" class="slide-item">دسته بندی</a>
                            </li>
                        @endcan
                        @can('product_category_list')
                            <li><a href="{{ route('admin.manage-library.index') }}" class="slide-item">کتابخانه</a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcan

            @canany(['product_category_list', 'product_list', 'encyclopedia_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="feather feather-share-2 sidemenu_icon"></i>
                        <span class="side-menu__label">دپارتمان آموزش</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('product_encyclopedia_list')
                            <li><a href="{{ route('admin.education-categories.index') }}" class="slide-item">دسته بندی</a>
                            </li>
                        @endcan
                        @can('product_category_list')
                            <li><a href="{{ route('admin.manage-educations.index') }}" class="slide-item">دوره های آموزشی</a>
                            </li>
                        @endcan

                        @can('product_category_list')
                            <li><a href="{{ route('admin.manage-chapters.create') }}" class="slide-item">ایجاد سرفصل
                                    دوره</a>
                            </li>
                        @endcan

                        @can('product_category_list')
                        <li><a href="{{ route('admin.manage-lessons.create') }}" class="slide-item">ایجاد جلسات
                                دوره</a>
                        </li>
                    @endcan

                        {{-- @can('product_category_list')
                        <li><a href="" class="slide-item">دوره های آنلاین</a>
                        </li>
                    @endcan --}}
                    </ul>
                </li>
            @endcan

            @canany(['product_category_list', 'product_list', 'encyclopedia_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="feather feather-share-2 sidemenu_icon"></i>
                        <span class="side-menu__label">محصولات</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('product_encyclopedia_list')
                            <li><a href="{{ route('admin.product-encyclopedia.index') }}" class="slide-item">دانشنامه</a>
                            </li>
                        @endcan
                        @can('product_category_list')
                            <li><a href="{{ route('admin.product-category.index') }}" class="slide-item">دسته بندی</a>
                            </li>
                        @endcan
                        @can('product_list')
                            <li><a href="{{ route('admin.product.index') }}" class="slide-item">محصولات</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['form_contact_list', 'comment_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-file-text-o sidemenu_icon"></i>
                        <span class="side-menu__label">فرم های ارتباطی</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('form_contact_list')
                            <li><a href="{{ route('admin.form.contact.index') }}" class="slide-item">تماس با ما
                                    @if ($contact_form)
                                        <span class="badge badge-danger mr-2">{{ $contact_form }}</span>
                                    @endif
                                </a></li>
                        @endcan

                        @can('comment_list')
                            <li><a href="{{ route('admin.form.comment.index') }}" class="slide-item">نظرات
                                    @if ($contact_form)
                                        <span class="badge badge-danger mr-2">{{ $contact_form }}</span>
                                    @endif
                                </a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
            @canany(['profile_list', 'slider_list', 'meta_list', 'about_list', 'contact_list', 'upload_list',
                'setting_list', 'lang_set_list', 'site_word_list', 'redirect_list'])
                <li class="slide">
                    <a class="side-menu__item" data-toggle="slide" href="#">
                        <i class="fa fa-cogs sidemenu_icon"></i>
                        <span class="side-menu__label">مدیریت سایت</span><i class="angle fa fa-angle-left"></i>
                    </a>
                    <ul class="slide-menu">
                        @can('media_list')
                            <li><a href="{{ route('admin.media.index') }}" class="slide-item">رسانه</a></li>
                        @endcan
                        @can('lang_set_list')
                            <li><a href="{{ route('admin.lang-set.index') }}" class="slide-item">زبان های سایت</a></li>
                        @endcan
                        @can('profile_list')
                            <li><a href="{{ route('admin.profile.show') }}" class="slide-item">پروفایل</a></li>
                        @endcan
                        @can('slider_list')
                            <li><a href="{{ route('admin.slider.index') }}" class="slide-item">اسلایدر</a></li>
                        @endcan
                        @can('meta_list')
                            <li><a href="{{ route('admin.meta.index') }}" class="slide-item">متا(سئو)</a></li>
                        @endcan
                        @can('about_list')
                            <li><a href="{{ route('admin.about.index') }}" class="slide-item">درباره ما</a></li>
                        @endcan
                        @can('contact_list')
                            <li><a href="{{ route('admin.contact.index') }}" class="slide-item">تماس با ما</a></li>
                        @endcan
                        @can('upload_list')
                            <li><a href="{{ route('admin.upload.index') }}" class="slide-item">آپلود فایل</a></li>
                        @endcan
                        @can('setting_list')
                            <li><a href="{{ route('admin.setting.index') }}" class="slide-item">تنظیمات سایت</a></li>
                        @endcan
                        @can('site_word_list')
                            <li><a href="{{ route('admin.site-word.index') }}" class="slide-item">واژه های سایت</a></li>
                        @endcan
                        @can('redirect_list')
                            <li><a href="{{ route('admin.redirect.index') }}" class="slide-item">ریدایرکت</a></li>
                        @endcan
                        @can('upload_sitemap_list')
                            <li><a href="{{ route('admin.upload-sitemaps.index') }}" class="slide-item">سایت مپ</a></li>
                        @endcan
                        @can('upload_robot_list')
                            <li><a href="{{ route('admin.upload-robots.index') }}" class="slide-item">روبوتس</a></li>
                        @endcan
                    </ul>
                </li>
            @endcan
        </ul>
    </div>
</aside>
<!--aside closed-->
