@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        table *
        {
            /*font-size: 13px;*/
        }
        table.dataTable tbody td, table.dataTable thead td
        {
            padding: 6px!important;
        }
        table.dataTable tbody th, table.dataTable thead th
        {
            padding: 10px 6px!important;
            /*font-size: 13px!important;*/
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('user_create')
                        <a href="{{route('admin.user.create')}}" class="btn btn-primary float-left">افزودن</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                {{-- <th class="border-bottom-0">ردیف</th> --}}
                                <th class="border-bottom-0">نام</th>
                                <th class="border-bottom-0">ایمیل</th>
                                <th class="border-bottom-0">پیام</th>
                                <th class="border-bottom-0">وضعیت</th>
                                @canany(['comment_delete'])
                                <th class="border-bottom-0">عملیات</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>
                                        {{$item->name}}
                                    </td>
                                    <td>
                                        {{$item->email}}
                                    </td>
                                     <td>
                                        <a tabindex="0" data-toggle="popover" data-trigger="focus" role="button" data-content="{{$item->message}}" data-original-title="شرح پیام" class="popover_125 btn btn-sm btn-primary">کلیک کنید
                                        </a>
                                    </td>
                                    <td>
                                        @if($item->status)
                                            <span class="text-success ml-1">فعال</span>
                                            <a href="{{route('admin.comment.status',$item->id)}}">
                                                <i class="fa fa-close text-danger"></i>
                                            </a>
                                        @else
                                            <span class="text-danger ml-1">مسدود</span>
                                            <a href="{{route('admin.comment.status',$item->id)}}">
                                                <i class="fa fa-check text-success"></i>
                                            </a>
                                        @endif
                                    </td>
                                  
                                    @canany(['comment_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('comment_delete')
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['admin.comment.destroy', $item->id] ]) !!}
                                                <button class="action-btns1" data-toggle="tooltip"
                                                        data-placement="top" title="حذف"
                                                        onclick="return confirm('برای حذف مطمئن هستید؟')">
                                                    <i class="feather feather-trash-2 text-danger"></i>
                                                </button>
                                                {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
