@extends('admin.layouts.app', ['req' => true, 'file_upload' => true, 'editor' => true])

@section('content')
<div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header  border-0">
                <h4 class="card-title">
                    {{ $title }}
                </h4>
            </div>
            <hr>

            <div class="card-body">
                {{ Form::open(['route' => 'admin.manage-lessons.store', 'method' => 'POST', 'id' => 'form_req', 'files' => true]) }}
                <div class="row">
                    <nav class="w-100">
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                            @foreach (tab_langs() as $lang)
                            <button class="nav-link {{ $lang->status == 'default' ? 'active' : '' }}"
                                id="nav-{{ $lang->lang }}-tab" data-toggle="tab"
                                data-target="#nav-{{ $lang->lang }}" type="button" role="tab"
                                aria-controls="nav-{{ $lang->lang }}"
                                aria-selected="false">{{ $lang->lang }}</button>
                            @endforeach
                        </div>
                    </nav>
                    <div class="tab-content w-100" id="nav-tabContent">
                        @foreach (tab_langs() as $lang)
                        <div class="tab-pane fade {{ $lang->status == 'default' ? 'show active' : '' }} {{ $lang->align == 'ltr' ? 'ltr_tab' : '' }}"
                            id="nav-{{ $lang->lang }}" role="tabpanel"
                            aria-labelledby="nav-{{ $lang->lang }}-tab">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{ Form::label($lang->status == 'default' ? 'status' : 'status_' . $lang->lang, 'وضعیت  *') }}
                                            {{ Form::select($lang->status == 'default' ? 'status' : 'status_' . $lang->lang, ['pending' => 'عدم انتشار', 'active' => 'انتشار'], null, ['class' => 'form-control select2-show-search custom-select', 'data-placeholder' => 'انتخاب کنید']) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{ Form::label('edu_id', 'انتخاب دوره آموزشی *') }}
                                            {{ Form::select('edu_id', array_pluck($cats, 'title', 'id', ['', 'انتخاب کنید']), null, ['id' => 'edu_select', 'class' => 'form-control select2-show-search custom-select', 'data-placeholder' => 'انتخاب کنید', 'required']) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{ Form::label('chapter_id', 'انتخاب سرفصل جلسه *') }}
                                            {{ Form::select('chapter_id', ['', 'انتخاب کنید'], null, ['id' => 'chapter_select', 'class' => 'form-control select2-show-search custom-select', 'data-placeholder' => 'انتخاب کنید', 'required']) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{ Form::label($lang->status == 'default' ? 'title' : 'title_' . $lang->lang, 'عنوان ') }}
                                            {{ Form::text($lang->status == 'default' ? 'title' : 'title_' . $lang->lang, null, ['class' => 'form-control']) }}
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            {{ Form::label('amount', 'قیمت جلسه') }}
                                            {{ Form::number('amount', 0, ['class' => 'form-control']) }}
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            {{Form::label('commission', 'سهم مدرس (حداکثر 100) *')}}
                                            {{ Form::number('commission', 0, array('class' => 'form-control slug_input','placeholder'=>'درصد فروش (حداکثر 100)','required' , 'max' => 100)) }}
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            {{ Form::label('link', 'لینک جلسه') }}
                                            {{ Form::text('link', null, ['class' => 'form-control']) }}
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        {{ Form::label($lang->status == 'default' ? 'text' : 'text_' . $lang->lang, 'توضیحات') }}
                                        <div class="form-group form-group-post">
                                            {{ Form::textarea($lang->status == 'default' ? 'text' : 'text_' . $lang->lang, null, ['class' => 'form-control textarea_' . $lang->align]) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            {{ Form::label('slug', 'اسلاگ  *') }}
                            {{ Form::text('slug', null, ['class' => 'form-control slug_input', 'data-placeholder' => 'انتخاب کنید', 'required']) }}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('photo', 'تصویر * ') }}
                            {{ Form::file('photo', ['class' => 'dropify', 'data-height' => '180', 'accept' => '.jpg,.jpeg,.png,.webp', 'required']) }}
                        </div>
                        <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                        <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('attachment', 'فایل ضمیمه * ') }}
                            {{ Form::file('attachment', ['class' => 'dropify', 'data-height' => '180', 'accept' => '.pdf']) }}
                        </div>
                        <p class="text-danger">_<small>حداکثر حجم فایل 5M می باشد</small></p>
                        <p class="text-danger">_<small>فرمت تصویر فقط باید PDF باشد</small></p>
                    </div>
                    <div class="col-md-12 text-left">
                        <hr />
                        {{ Form::submit('افزودن', ['class' => 'btn btn-primary', 'onclick' => "return confirm('برای ارسال فرم مطمئن هستید؟')"]) }}
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        $('#edu_select').change(function() {
            var id = $(this).val()
            $.get("{{route('admin.lesson-chapters' , '__id__')}}".replace('__id__', id), function(response) {
                if (response.success) {
                    let select = $('#chapter_select');
                    select.empty();
                    select.append('<option value="">انتخاب کنید</option>');
                    $.each(response.data, function(index, item) {
                        select.append(`<option value="${item.id}">${item.title}</option>`)
                    })
                }

            })
        })

    })
</script>
@endsection

@push('in_tag_script')
@endpush