@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
<div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header  border-0">
                <h4 class="card-title">
                    {{$title}}
                </h4>
            </div>
            <hr>

            <div class="card-body">
                {{ Form::open(array('route' => 'admin.manage-educations.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                <div class="row">
                    <nav class="w-100">
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                            @foreach(tab_langs() as $lang)
                            <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                aria-controls="nav-{{$lang->lang}}"
                                aria-selected="false">{{$lang->lang}}</button>
                            @endforeach
                        </div>
                    </nav>
                    <div class="tab-content w-100" id="nav-tabContent">
                        @foreach(tab_langs() as $lang)
                        <div
                            class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                            id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                            {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{Form::label('type', 'نوع دوره *')}}
                                            {{ Form::select('type', [ 'online' => 'آنلاین' ,'offline' => 'آفلاین' ,'' => 'انتخاب کنید'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{Form::label('teacher', 'مدرس دوره *')}}
                                            {{ Form::select('teacher', array_pluck($users, 'name', 'id',['','انتخاب کنید']), null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, 'عنوان ')}}
                                            {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,null, array('class' => 'form-control'))}}
                                        </div>
                                    </div>
                                    <!-- <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'top_text':'top_text_'.$lang->lang, 'توضیحات بالای جدول(حداکثر 1000 کاراکتر)')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'top_text':'top_text_'.$lang->lang, null, array('class' => 'form-control','rows'=>3))}}
                                                </div>
                                            </div> -->
                                    <div class="col-md-12">
                                        {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, 'توضیحات')}}
                                        <div class="form-group form-group-post">
                                            {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                        </div>
                                    </div>
                                    <!-- <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text2':'text2_'.$lang->lang, 'مشخصات محصول')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text2':'text2_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div> -->
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {{Form::label('category_id', 'دسته بندی  *')}}
                            {{ Form::select('category_id', array_pluck($cats_id, 'title', 'id',['','انتخاب کنید']), null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {{Form::label('level', 'سطح دوره *')}}
                            {{ Form::select('level', [ 'expert' => 'تخصصی' ,'advanced' => 'پیشرفته' ,'intermediate' => 'متوسط' , 'beginner' => 'مقدماتی' , '' , ''=>'انتخاب کنید'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید','required')) }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {{Form::label('amount', 'مبلغ  *')}}
                            {{ Form::text('amount', null, array('class' => 'form-control slug_input','data-placeholder'=>'مبلغ دوره','required')) }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {{Form::label('commission', 'سهم مدرس (حداکثر 100) *')}}
                            {{ Form::number('commission', 0, array('class' => 'form-control slug_input','placeholder'=>'درصد فروش (حداکثر 100)','required' , 'max' => 100)) }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {{Form::label('slug', 'اسلاگ  *')}}
                            {{ Form::text('slug', null, array('class' => 'form-control slug_input','data-placeholder'=>'انتخاب کنید','required')) }}
                        </div>
                    </div>

                    <div class="col-md-3 mt-3">
                        <div class="form-group">
                            {{Form::label('intro_link', 'لینک معرفی  *')}}
                            {{ Form::text('intro_link', null, array('class' => 'form-control','data-placeholder'=>'..','required')) }}
                        </div>
                    </div>

                    <div class="col-md-3 mt-3">
                        <div class="form-group">
                            {{Form::label('start_rege_date', 'تاریخ شروع ثبت نام  *')}}
                            {{ Form::text('start_rege_date', null, array('class' => 'form-control date-picker slug_input','required')) }}
                        </div>
                    </div>

                    <div class="col-md-3 mt-3">
                        <div class="form-group">
                            {{Form::label('end_rege_date', 'تاریخ پایان ثبت نام  *')}}
                            {{ Form::text('end_rege_date', null, array('class' => 'form-control date-picker slug_input','required')) }}
                        </div>
                    </div>

                    <div class="col-md-3 mt-3">
                        <div class="form-group">
                            {{Form::label('start_date', 'تاریخ شروع دوره  *')}}
                            {{ Form::text('start_date', null, array('class' => 'form-control date-picker slug_input','required')) }}
                        </div>
                    </div>

                    <div class="col-md-3 mt-3">
                        <div class="form-group">
                            {{Form::label('end_date', 'تاریخ پایان دوره  *')}}
                            {{ Form::text('end_date', null, array('class' => 'form-control date-picker slug_input','required')) }}
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-group">
                            {{Form::label('photo', 'تصویر * ')}}
                            {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','required'))}}
                        </div>
                        <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                        <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            {{Form::label('attachment', 'فایل ضمیمه * ')}}
                            {{Form::file('attachment', array('class' => 'dropify','data-height'=>'180','accept' => '.pdf'))}}
                        </div>
                        <p class="text-danger">_<small>حداکثر حجم فایل 5M می باشد</small></p>
                        <p class="text-danger">_<small>فرمت تصویر فقط باید PDF باشد</small></p>
                    </div>
                    <div class="col-md-12 text-left">
                        <hr />
                        {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        console.log("hello from jquery");

    })
    $(".date-picker").pDatepicker({
        observer: true,
        format: 'YYYY/MM/DD',
        autoClose: true,
        initialValue: false
    });
</script>
@endsection

@push('in_tag_script')

@endpush