@php
  $i=0;
@endphp
@foreach($items as $item)
  @php
    $i++;
  @endphp
  <tr>
    <td>{{$key+1}} - {{$i}}</td>
    <td>
      {{$item->title}}
    </td>
    <td>
      @if($item->photo && is_file($item->photo->path))
        <img src="{{url($item->photo->path)}}" height="100px">
      @else
        ثبت نشده
      @endif
    </td>
    @can('product_category_sort')
      <td>
        {!! Form::open(['method' => 'POST', 'route' => ['admin.product-category.sort', $item->id] ]) !!}
        <input type="number" name="sort" class="form-control w-60px" value="{{$item->sort}}" onchange="return this.form.submit()">
        {!! Form::close() !!}
      </td>
    @endcan
    @canany(['product_category_edit','product_category_delete'])
      <td>
        <div class="d-flex">
          @can('product_category_edit')
            <a href="{{route('admin.product-category.edit',$item->id)}}"
               class="action-btns1">
              <i class="feather feather-edit-2  text-success"
                 data-toggle="tooltip" data-placement="top"
                 title="ویرایش"></i>
            </a>
          @endcan
          @can('product_category_delete')
            {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product-category.destroy', $item->id] ]) !!}
            <button class="action-btns1" data-toggle="tooltip"
                    data-placement="top" title="حذف"
                    onclick="return confirm('برای حذف مطمئن هستید؟')">
              <i class="feather feather-trash-2 text-danger"></i>
            </button>
            {!! Form::close() !!}
          @endcan
        </div>
      </td>
    @endcan
  </tr>
@endforeach