@extends('admin.layouts.app',['req'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.role.store', 'method' => 'POST','id'=>'form_req')) }}
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('title', 'نام سطح درسترسی *')}}
                {{Form::text('title', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('name', 'کد سطح درسترسی *')}}
                {{Form::text('name', null, array('class' => 'form-control d-ltr text-end','required'))}}
              </div>
            </div>
            <div class="col-12">
              @foreach($permission_cats as $permission_cat)
                  @if(Auth::user()->roles->first()->id>1)
                    @can($permission_cat->access_list_code)
                      <div class="permission_cat_box">
                        <h4>{{$permission_cat->table_name}}</h4>
                        <hr>
                        @if(count($permission_cat->permissions))
                          @foreach($permission_cat->permissions as $permission)

                            <label class="custom-switch ml-3">

                              {{ Form::checkbox('permission[]', $permission->id, false) }}

                              <span class="mr-1">  {{$permission->title}} </span>
                            </label>
                          @endforeach
                        @else
                          فاقد دسترسی
                        @endif
                      </div>
                    @endcan
                  @else
                    <div class="permission_cat_box">
                      <h4>{{$permission_cat->table_name}}</h4>
                      <hr>
                      @if(count($permission_cat->permissions))
                        @foreach($permission_cat->permissions as $permission)

                          <label class="custom-switch ml-3">

                            {{ Form::checkbox('permission[]', $permission->id, false) }}

                            <span class="mr-1">  {{$permission->title}} </span>
                          </label>
                        @endforeach
                      @else
                        فاقد دسترسی
                      @endif
                    </div>
                  @endif
              @endforeach
            </div>
            <div class="col-md-12">
              <hr/>
              {{Form::submit('افزودن',array('class'=>'btn btn-primary float-left','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('in_tag_script')

@endpush
