@extends('admin.layouts.app',['tbl'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            @can('permission_create')
            <a href="{{route('admin.permission.create')}}" class="btn btn-primary float-left">افزودن</a>
            @endcan
          </h4>
        </div>

        <div class="card-body">
          <div class="accordion" id="accordionExample">
            @foreach($items as $key=>$value)
              <div class="card mb-1">
                <div class="card-header p-2" id="headingOne{{$key}}">
                  <h2 class="mb-0 w-100">
                    <button class="btn btn-block collapsed" type="button" data-toggle="collapse" data-target="#collapseOne{{$key}}" aria-expanded="true" aria-controls="collapseOne{{$key}}">
                      <h5 class="mb-0">
                        {{$value->table_name}}
                      </h5>
                    </button>
                  </h2>
                </div>

                <div id="collapseOne{{$key}}" class="collapse" aria-labelledby="headingOne{{$key}}" data-parent="#accordionExample">
                  <div class="card-body">
                    @foreach($value->permissions as $permission)
                      <div class="permission_box">
                        <p>
                          {{$permission->title}}
                        </p>
                        @can('permission_delete')
                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.permission.destroy', $permission->id] ]) !!}
                          <button class="action-btns1 float-left" data-toggle="tooltip"
                                  data-placement="top" title="حذف"
                                  onclick="return confirm('برای حذف مطمئن هستید؟')">
                            <i class="fa fa-trash text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                        @can('permission_edit')
                          <a href="{{route('admin.permission.edit',$permission->id)}}"
                             class="action-btns1 float-left" data-toggle="tooltip" data-placement="top"
                             title="ویرایش">
                            <i class="fa fa-edit  text-success"></i>
                          </a>
                        @endcan
                      </div>
                    @endforeach
                  </div>
                </div>
              </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
