<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('redirects', function (Blueprint $table) {
            $table->id();
            $table->string('title',200)->nullable();
            $table->text('from')->nullable();
            $table->text('to')->nullable();
            $table->enum('type', ['410', '301', '302', '404'])->default('410');
            $table->enum('groups', ['yes','no'])->default('no');
            $table->enum('status', ['active','pending'])->default('active');
            $table->integer('user_id_create')->nullable();
            $table->integer('user_id_edit')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('redirects');
    }
};
