<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->references('id')->on('product_categories')->cascadeOnDelete();
            $table->string('title',200)->nullable();
            $table->string('slug',300);
            $table->longText('text')->nullable();
            $table->string('meta_title',255)->nullable();
            $table->longText('meta_description')->nullable();
            $table->integer('seen')->nullable()->default(0);
            $table->enum('status', ['active','pending'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
