<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('metas', function (Blueprint $table) {
            $table->id();
            $table->string('name_page',200)->nullable();
            $table->string('title_page',200)->nullable();
            $table->text('link')->nullable();
            $table->text('description')->nullable();
            $table->longText('schema')->nullable();
            $table->text('robots')->nullable();
            $table->text('canonical')->nullable();
            $table->enum('status', ['active','pending'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('metas');
    }
};
