<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->references('id')->on('blog_categories')->cascadeOnDelete();
            $table->string('title',200);
            $table->string('slug',300);
            $table->longText('text')->nullable();
            $table->longText('tags')->nullable();
            $table->string('author',100)->nullable();
            $table->string('meta_title',255)->nullable();
            $table->string('meta_description',300)->nullable();
            $table->integer('seen')->nullable()->default(0);
            $table->integer('sort')->nullable()->default(1000);
            $table->enum('status', ['active','pending'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
