<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('withdraw_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->contrained();
            $table->bigInteger('amount');
            $table->longText('description');
            $table->enum('status' , ['pending' , 'reject' , 'accept'])->default('pending');
            $table->boolean('paid')->default(0);
            $table->timestamp('paid_date')->nullable();
            $table->text('transaction_number');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('withdraw_requests');
    }
};
