<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('education', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cat_id')->contrained('education_cats');
            $table->foreignId('teacher_id')->contrained('users');
            $table->enum('type' , ['offline' , 'online']);
            $table->text('title');
            $table->text('slug');
            $table->bigInteger('amount');
            $table->longText('text');
            $table->enum('status' , ['pending' , 'active']);
            $table->text('level');
            $table->timestamp('start_rege_date')->nullable();
            $table->timestamp('end_rege_date')->nullable();
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('education');
    }
};
