<?php

namespace App;
use App\Models\Wallet;

trait hasWallet
{
    public function wallet(){
        return $this->morphOne(Wallet::class  , 'walletable');
    }

    public function getWallet(){
        return $this->wallet()->firstOrCreate([
            'walletable_id' => $this->id,
            'walletable_type' => get_class($this)
        ]);
    }

    public function deposit($amount , $des = null){
        return $this->getWallet()->deposit($amount ,$des);
    }

    
    public function withdraw($amount , $des = null){
        return $this->getWallet()->withdraw($amount ,$des);
    }

    public function balance(){
        return $this->getWallet()->balance;
    }
}
