<?php

namespace App\Services;
use Illuminate\Support\Facades\DB;
use Exception;
class TransactionService
{

    public function __construct()
    {
        //
    }

    public static function run(callable $callback){
        DB::beginTransaction();
        try {
            $res = $callback();
            DB::commit();
            return [
                'result' => true,
                'message' => 'complete!'
            ];
        } catch (Exception $e) {
            DB::rollBack();
            return [
             'result' => false,
             'message' => $e->getMessage()
            ];
        }
    }
}
