<?php

namespace App\Services;

use App\Http\Requests\Library\LibraryCatRequest;
use App\Http\Requests\Library\LibraryRequest;
use App\Models\Library;
use App\Models\LibraryCat;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class LibraryService
{

    public function __construct()
    {
        //
    }

    public function lib_create(LibraryRequest $request){
        $lib = Library::create([
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'status' => $request->status,
            'cat_id' => $request->category_id,
        ]);

        if ($request->hasFile('photo')) {
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $lib->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            $photo = new Photo();
            $photo->type = 'attachment';
            $photo->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $lib->attachment()->save($photo);
        }


    }

    public function lib_update(LibraryRequest $request , Library $lib){
        $lib->update([
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'status' => $request->status,
            'cat_id' => $request->category_id,
        ]);

        if ($request->hasFile('photo')) {
            if ($lib->photo) {
                if (is_file($lib->photo->path)) {
                    File::delete($lib->photo->path);
                    delete_directory($lib->photo->path);
                }
                $lib->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $lib->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            if ($lib->attachment) {
                if (is_file($lib->attachment->path)) {
                    File::delete($lib->attachment->path);
                    delete_directory($lib->attachment->path);
                }
                $lib->attachment->delete();
            }
            $attach = new Photo();
            $attach->type = 'attachment';
            $attach->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $lib->attachment()->save($attach);
        }

        store_lang($lib, $request, ['title','text', 'status'], 'edit');
    }

    public function lib_delete(Library $lib){
        $lib->delete();
    }

    public function cat_store(LibraryCatRequest $request){
        $cat = LibraryCat::create([
            'parent_id' => $request->parent_id != 'father' ? $request->parent_id : null,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status,
            'slug' => $request->slug
        ]);

        if ($request->hasFile('photo')) {
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/product-category' . '/');
            $cat->photo()->save($photo);
        }

        store_lang($cat, $request, ['title','text', 'status'], 'create');
    }

    public function cat_update(LibraryCatRequest $request , LibraryCat $cat){
        $cat->update([
            'parent_id' => $request->parent_id != 'father' ? $request->parent_id : null,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status,
            'slug' => $request->slug
        ]);
        if ($request->hasFile('photo')) {
            if ($cat->photo) {
                if (is_file($cat->photo->path)) {
                    File::delete($cat->photo->path);
                    delete_directory($cat->photo->path);
                }
                $cat->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/product-category' . '/');
            $cat->photo()->save($photo);
        }

        store_lang($cat, $request, ['title','text', 'status'], 'edit');
    }

    public function cat_delete(LibraryCat $cat){
        $cat->delete();
    }

    public function sort_cat(LibraryCat $cat , $priority){
        $cat->update([
            'priority' => $priority
        ]);
    }
}
