<?php

namespace App\Services;

use App\Http\Requests\Financial\withdrawReqeust;
use App\Models\WithdrawRequest;
use Illuminate\Http\Request;
use Carbon\Carbon;

class FinancialService
{

    public function __construct()
    {
        //
    }

    public function withdraw_request(withdrawReqeust $r){
        auth()->user()->withdraw( (int) $r->amount , 'درخواست برداشت');
        auth()->user()->withdrawRequests()->create([
            'amount' => $r->amount,
            'description' => $r->note,
            'status' => 'pending',
            'destination' => $r->destination,
            'method' => $r->method
        ]);
    }

    public function withdraw_result(Request $request , WithdrawRequest $withdraw){
        if ($request->type == 'accept') {
            $withdraw->update([
                'paid' => 1,
                'paid_date'=> Carbon::now(),
                'transaction_number' => $request->transaction_code,
                'admin_id' => auth()->user()->id,
                'status' => 'accept'
            ]);
        }else{
            $withdraw->update([
                'admin_id' => auth()->user()->id,
                'admin_note' => $request->reason,
                'status' => 'reject'
            ]);

            $withdraw->user->deposit($withdraw->amount , 'cancell withdraw');
        }
    }
}
