<?php

namespace App\Services;

use App\Http\Requests\Education\EducationCatRequest;
use App\Http\Requests\Education\EducationChaptersRequest;
use App\Http\Requests\Education\EducationLessonsRequest;
use App\Http\Requests\Education\EducationRequest;
use App\Models\Chapter;
use App\Models\Education;
use App\Models\EducationCat;
use App\Models\Lesson;
use App\Models\Photo;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;
use Illuminate\Http\Request;

class EducationService
{

    public function __construct()
    {
        //
    }

    public function cat_store(EducationCatRequest $request){
        $cat = EducationCat::create([
            'parent_id' => $request->parent_id != 'father' ? $request->parent_id : null,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status,
            'slug' => $request->slug
        ]);

        if ($request->hasFile('photo')) {
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/product-category' . '/');
            $cat->photo()->save($photo);
        }

        store_lang($cat, $request, ['title','text', 'status'], 'create');
    }

    public function cat_update(EducationCatRequest $request , EducationCat $cat){
        $cat->update([
            'parent_id' => $request->parent_id != 'father' ? $request->parent_id : null,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status,
            'slug' => $request->slug
        ]);
        if ($request->hasFile('photo')) {
            if ($cat->photo) {
                if (is_file($cat->photo->path)) {
                    File::delete($cat->photo->path);
                    delete_directory($cat->photo->path);
                }
                $cat->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/product-category' . '/');
            $cat->photo()->save($photo);
        }

        store_lang($cat, $request, ['title','text', 'status'], 'edit');
    }

    public function cat_delete(EducationCat $cat){
        $cat->delete();
    }

    public function sort_cat(EducationCat $cat , $priority){
        $cat->update([
            'priority' => $priority
        ]);
    }

    public function education_create(EducationRequest $request){
        $cat = Education::create([
            'status' => $request->status,
            'type' => $request->type,
            'commission' => $request->commission,
            'title' => $request->title,
            'text' => $request->text,
            'cat_id' => $request->category_id,
            'amount' => $request->amount,
            'slug' => $request->slug,
            'start_rege_date' => Carbon::parse(my_gdate($request->start_rege_date)),
            'end_rege_date' => Carbon::parse(my_gdate($request->end_rege_date)),
            'start_date' => Carbon::parse(my_gdate($request->start_date)),
            'end_date' => Carbon::parse(my_gdate($request->end_date)),
            'teacher_id' => $request->teacher,
            'level' => $request->level,
            'intro_link' => $request->intro_link
        ]);

        if ($request->hasFile('photo')) {
            if ($cat->photo) {
                if (is_file($cat->photo->path)) {
                    File::delete($cat->photo->path);
                    delete_directory($cat->photo->path);
                }
                $cat->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $cat->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            if ($cat->attachment) {
                if (is_file($cat->attachment->path)) {
                    File::delete($cat->attachment->path);
                    delete_directory($cat->attachment->path);
                }
                $cat->attachment->delete();
            }
            $attach = new Photo();
            $attach->type = 'attachment';
            $attach->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $cat->attachment()->save($attach);
        }
    }

    public function education_update(EducationRequest $request , Education $item){
        $item->update([
            'status' => $request->status,
            'type' => $request->type,
            'commission' => $request->commission,
            'title' => $request->title,
            'text' => $request->text,
            'cat_id' => $request->category_id,
            'amount' => $request->amount,
            'slug' => $request->slug,
            'start_rege_date' => Carbon::parse(my_gdate($request->start_rege_date)),
            'end_rege_date' => Carbon::parse(my_gdate($request->end_rege_date)),
            'start_date' => Carbon::parse(my_gdate($request->start_date)),
            'end_date' => Carbon::parse(my_gdate($request->end_date)),
            'teacher_id' => $request->teacher,
            'level' => $request->level,
            'intro_link' => $request->intro_link
        ]);

        if ($request->hasFile('photo')) {
            if ($item->photo) {
                if (is_file($item->photo->path)) {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $item->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            if ($item->attachment) {
                if (is_file($item->attachment->path)) {
                    File::delete($item->attachment->path);
                    delete_directory($item->attachment->path);
                }
                $item->attachment->delete();
            }
            $attach = new Photo();
            $attach->type = 'attachment';
            $attach->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $item->attachment()->save($attach);
        }

        store_lang($item, $request, ['title','text', 'status'], 'edit');
    }

    public function chapter_create(EducationChaptersRequest $request){
        $chapter = Chapter::create([
            'education_id' => $request->edu_id,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status
        ]);

        store_lang($chapter, $request, ['title','text', 'status'], 'edit');
    }

    public function chapter_update(EducationChaptersRequest $request , Chapter $chapter){
        $chapter->update([
            'education_id' => $request->edu_id,
            'title' => $request->title,
            'text' => $request->text,
            'status' => $request->status
        ]);

        store_lang($chapter, $request, ['title','text', 'status'], 'edit');
    }

    public function lesson_create(EducationLessonsRequest $request){
        $lesson = Lesson::create([
            'status' => $request->status,
            'title' => $request->title,
            'commission' => $request->commission,
            'text' => $request->text,
            'amount' => $request->amount,
            'slug' => $request->slug,
            'edu_id' => $request->edu_id,
            'chapter_id' => $request->chapter_id,
            'link' => $request->link
        ]);

        if ($request->hasFile('photo')) {
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $lesson->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            if ($lesson->attachment) {
                if (is_file($lesson->attachment->path)) {
                    File::delete($lesson->attachment->path);
                    delete_directory($lesson->attachment->path);
                }
                $lesson->attachment->delete();
            }
            $attach = new Photo();
            $attach->type = 'attachment';
            $attach->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $lesson->attachment()->save($attach);
        }
    }

    public function lesson_update(EducationLessonsRequest $request , Lesson $lesson){
        $lesson->update([
            'status' => $request->status,
            'title' => $request->title,
            'commission' => $request->commission,
            'text' => $request->text,
            'amount' => $request->amount,
            'slug' => $request->slug,
            'edu_id' => $request->edu_id,
            'chapter_id' => $request->chapter_id,
            'link' => $request->link
        ]);

        if ($request->hasFile('photo')) {
            if ($lesson->photo) {
                if (is_file($lesson->photo->path)) {
                    File::delete($lesson->photo->path);
                    delete_directory($lesson->photo->path);
                }
                $lesson->photo->delete();
            }
            $photo = new Photo();
            $photo->type = 'photo';
            $photo->path = file_store($request->photo, 'assets/admin/uploads/library' . '/');
            $lesson->photo()->save($photo);
        }

        if ($request->hasFile('attachment')) {
            if ($lesson->attachment) {
                if (is_file($lesson->attachment->path)) {
                    File::delete($lesson->attachment->path);
                    delete_directory($lesson->attachment->path);
                }
                $lesson->attachment->delete();
            }
            $attach = new Photo();
            $attach->type = 'attachment';
            $attach->path = file_store($request->attachment, 'assets/admin/uploads/library' . '/');
            $lesson->attachment()->save($attach);
        }

    }

    public function add_group(Education $edu , Request $request){
        $edu->groups()->create([
            'name' => $request->gp_name,
            'start_time' => Carbon::parse(my_gdate_time($request->gp_date_start)),
            'end_time' => Carbon::parse(my_gdate_time($request->gp_date_end))
        ]);
    }
}
